.386p
_DATA        SEGMENT USE32 'DATA'
             ASSUME  CS:_DATA, DS:_DATA

INCLUDE  sm.inc

MAX_INSTRUCTION_SIZE  EQU  8


dci          MACRO itype, val, modf, instr, op1, op2, op3
             LOCAL beg, end
             DB    end - beg
             DB    modf
beg:
             IFB   <op3>
               IFB  <op2>
                 IFB <op1>
                   instr
                 ELSE
                   instr  op1
                 ENDIF
               ELSE
                 instr  op1, op2
               ENDIF
             ELSE
               instr  op1, op2, op3
             ENDIF
end:
             ORG    MAX_INSTRUCTION_SIZE + OFFSET beg
             DB   itype
             DB   val
             DD   0
             ENDM


; instruction types:

IT_ORD       EQU   0   ; ordinary instruction
IT_JUMP      EQU   1   ; jump, value should contain 0-based dest index
IT_CALL      EQU   2   ; call, value should contain 0-based index in imp table
IT_CBEGIN    EQU   3   ; instruction must contain offset Code_Begin, value
                       ; should contain offset inside instruction
IT_XOR       EQU   4   ; instruction contains xor value;
                       ; value's low nibble: 0-based xor value index,
                       ; high nibble: offest of imm value inside instruction
IT_CONST     EQU   5   ; instruction contains 08088405 constant xored with
                       ; value a, value is index of imm data inside instruction
IT_CSIZE     EQU   6   ; instruction contains number size of encrypted data
                       ; xored with value b


; modification flags

MODF_NONE    =  0
MODF_EAX     =  1
MODF_EDX     =  2
MODF_ECX     =  4
MODF_EBX     =  8
MODF_ESI     =  16
MODF_EDI     =  32
MODF_EBP     =  64
MODF_FLAGS   =  128

NO_VALUE     =  0


;
; code that allows to modify code segment and deciphers loader,
; instructions must be placed separately in random places but sequentally
; note that call and jump instructions must be relocated;
; calls point to the corresponding function name, this info is used by
; exefile generator, but the call itself will finally be referenced to the
; import jump
;
; also define modication flags
; that flag contains modification bits defined above
; if a bit of the flag is set then there must not be any code after, which
; contains the same modification bit in the properties
;

_wPTable     LABEL BYTE
             PUBLIC _wPTable

dci_begin    LABEL NEAR
                                   ; reserve address on stack for temp var
dci IT_ORD     NO_VALUE  MODF_NONE          push  ECX
                                   ; address of temp variable
dci IT_ORD     NO_VALUE  MODF_EDX           mov   EDX,ESP
dci IT_ORD     NO_VALUE  MODF_NONE          push  EDX
                                   ; execute_read_write
dci IT_ORD     NO_VALUE  MODF_NONE          push  40h
                                   ; size of region
dci IT_CSIZE   1         MODF_NONE          push  12345678h
dci IT_ORD     NO_VALUE  MODF_EBP           mov   EBP,ESP
                                   ; xor size with value b
dci IT_XOR     21h       MODF_NONE          <xor   DWORD PTR [EBP],12345678h>
                                   ; address of region
dci IT_CBEGIN  1         MODF_NONE          push  12345678h ; OFFSET Code_Begin
dci IT_CALL    0         MODF_EAX           call  mcs_GetCurrentProcess
dci IT_ORD     NO_VALUE  MODF_NONE          push  EAX
dci IT_CALL    1         MODF_EAX           call  mcs_VirtualProtectEx
dci IT_ORD     NO_VALUE  MODF_FLAGS         or    EAX,EAX
dci IT_ORD     NO_VALUE  MODF_FLAGS         pop   EAX
                                   ; opcode 0F 85... must be generated
dci IT_JUMP    15        MODF_NONE          jnz   fwd ; cnt1
dci IT_ORD     NO_VALUE  MODF_NONE          push  0
dci IT_CALL    2         MODF_NONE          call  mcs_ExitProcess
                                   ; cnt1: decipher code segment
                                   ; put data size on stack
dci IT_CSIZE   1         MODF_NONE          push  12345678h
                                   ; put xor value a on stack
dci IT_XOR     10h       MODF_NONE          push  12345678h
                                   ; put xor value b on stack
dci IT_XOR     11h       MODF_NONE          push  12345678h
                                   ; put constant 08088405 xored with value a
dci IT_CONST   1         MODF_NONE          push  08088405h
                                   ; stack addressing begins with [EBP]
dci IT_ORD     NO_VALUE  MODF_EBP           mov   EBP,ESP
                                   ; xor value c (seed for pseudorandom
                                   ; generator) - will be popped into EAX later
dci IT_XOR     12h       MODF_EBP           push  12345678h
                                   ; xor pushed constant
dci IT_XOR     20h       MODF_EBP           xor   [EBP],12345678h
                                   ; xor size with value b
dci IT_XOR     21h       MODF_EBP           <xor   DWORD PTR [EBP+12],12345678h>
                                   ; divide by 16 to obtain counter
dci IT_ORD     NO_VALUE  MODF_EBP           <shr   DWORD PTR [EBP+12],4>
                                   ; address of region - OFFSET Code_Begin
dci IT_CBEGIN  1         MODF_EBP+MODF_EDI  mov   EDI,12345678h
                                   ; decipher_next_block:
dci IT_XOR     23h       MODF_EBP+MODF_EDI  <xor   DWORD PTR [EDI],12345678h>
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI+MODF_EAX  pop   EAX
                                                        ; value c
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI+MODF_EAX  xor   [EDI],EAX
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI+MODF_EAX  <imul  DWORD PTR [EBP]>
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI+MODF_EAX  inc   EAX
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  push  EAX
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
                                                        ; get xor_val_b
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI+MODF_EAX  mov   EAX,[EBP+4]
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI+MODF_EAX  xor   [EDI],EAX
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI+MODF_EAX  ror   EAX,1
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  mov   [EBP+4],EAX  ; put xor_val_b
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
                                                        ; get xor_val_a
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI+MODF_EAX  mov   EAX,[EBP+8]
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI+MODF_EAX  xor   [EDI],EAX
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI+MODF_EAX  rol   EAX,1
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  mov   [EBP+8],EAX  ; put xor_val_a
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI  inc   EDI
                                                          ; counter
dci IT_ORD     NO_VALUE  MODF_EBP+MODF_EDI+MODF_FLAGS  <dec   DWORD PTR [EBP+12]>
                                   ; opcode 0F 85... must be generated
dci IT_JUMP    23        MODF_NONE          jnz   fwd ; decipher_next_block

dci_fin      LABEL NEAR

dci IT_ORD     NO_VALUE  MODF_NONE          add   ESP,20  ; including xor val c

dci_end      LABEL NEAR

fwd          LABEL NEAR

_wPTableSize DD    (dci_end - dci_begin) / (dci_end - dci_fin)
             PUBLIC _wPTableSize


_wPImpTable  LABEL BYTE
             PUBLIC _wPImpTable

icd_begin    LABEL NEAR

mcs_GetCurrentProcess:  icd 'GetCurrentProcess' 'kernel32.dll'
mcs_VirtualProtectEx:   icd 'VirtualProtectEx'  'kernel32.dll'

icd_fin      LABEL NEAR

mcs_ExitProcess:        icd 'ExitProcess'       'kernel32.dll'

icd_end      LABEL NEAR

_wPImpTableSize DD    (icd_end - icd_begin) / (icd_end - icd_fin)
                PUBLIC _wPImpTableSize


;-----------------------------------------------------------------------------
; table with dummy instructions and their properties
; structure of element:
; DB        the length of instruction, 0 for the last element, the last element
;           contains only this zero byte
;               low nibble contains length
;               high nibble contains length of immediate operand
;                 if bit 7 is set, immediate value must be in range 2..31
; DB        modification flags
;


inst         MACRO modf, i, op1, op2
             LOCAL beg, end
             DB    end - beg
             DB    modf
beg:
             IFB  <op2>
               IFB <op1>
                 i
               ELSE
                 i op1
               ENDIF
             ELSE
               i op1, op2
             ENDIF
end:
             ORG    MAX_INSTRUCTION_SIZE + OFFSET beg
             ENDM

instr2       MACRO ov, modf, i, op1, op2, op3
             LOCAL beg, end
             DB    (end - beg) or ov
             DB    modf
beg:
             IFB  <op3>
               IFB  <op2>
                 IFB <op1>
                   i
                 ELSE
                   i op1
                 ENDIF
               ELSE
                 i op1, op2
               ENDIF
             ELSE
               i op1, op2, op3
             ENDIF
end:
             ORG    MAX_INSTRUCTION_SIZE + OFFSET beg
             ENDM


_ITable      LABEL BYTE

; most used instructions first

ibegin       LABEL NEAR

instr2 40h MODF_EAX   DB 0B8h           ; mov EAX,12345678h
instr2 40h MODF_EBX   DB 0BBh           ; mov EBX,12345678h
instr2 40h MODF_ECX   DB 0B9h           ; mov ECX,12345678h
instr2 40h MODF_EDX   DB 0BAh           ; mov EDX,12345678h
instr2 40h MODF_ESI   DB 0BEh           ; mov ESI,12345678h
instr2 40h MODF_EDI   DB 0BFh           ; mov EDI,12345678h
instr2 40h MODF_EBP   DB 0BDh           ; mov EBP,12345678h

instr2 40h MODF_EAX+MODF_FLAGS  DB 005h           ; add EAX,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 081h, 0C3h     ; add EBX,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 081h, 0C1h     ; add ECX,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 081h, 0C2h     ; add EDX,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 081h, 0C6h     ; add ESI,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 081h, 0C7h     ; add EDI,12345678h
instr2 40h MODF_EBP+MODF_FLAGS  DB 081h, 0C5h     ; add EBP,12345678h

instr2 40h MODF_EAX+MODF_FLAGS  DB 02Dh            ; sub EAX,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 081h, 0EBh      ; sub EBX,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 081h, 0E9h      ; sub ECX,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 081h, 0EAh      ; sub EDX,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 081h, 0EEh      ; sub ESI,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 081h, 0EFh      ; sub EDI,12345678h
instr2 40h MODF_EBP+MODF_FLAGS  DB 081h, 0EDh      ; sub EBP,12345678h

instr2 40h MODF_EAX+MODF_FLAGS  DB 025h            ; and EAX,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 081h, 0E3h      ; and EBX,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 081h, 0E1h      ; and ECX,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 081h, 0E2h      ; and EDX,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 081h, 0E6h      ; and ESI,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 081h, 0E7h      ; and EDI,12345678h
instr2 40h MODF_EBP+MODF_FLAGS  DB 081h, 0E5h      ; and EBP,12345678h

instr2 40h MODF_EAX+MODF_FLAGS  DB 00Dh            ; or EAX,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 081h, 0CBh      ; or EBX,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 081h, 0C9h      ; or ECX,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 081h, 0CAh      ; or EDX,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 081h, 0CEh      ; or ESI,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 081h, 0CFh      ; or EDI,12345678h
instr2 40h MODF_EBP+MODF_FLAGS  DB 081h, 0CDh      ; or EBP,12345678h

instr2 40h MODF_EAX+MODF_FLAGS  DB 035h            ; xor EAX,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 081h, 0F3h      ; xor EBX,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 081h, 0F1h      ; xor ECX,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 081h, 0F2h      ; xor EDX,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 081h, 0F6h      ; xor ESI,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 081h, 0F7h      ; xor EDI,12345678h
instr2 40h MODF_EBP+MODF_FLAGS  DB 081h, 0F5h      ; xor EBP,12345678h

instr2 40h MODF_EAX+MODF_FLAGS  DB 0A9h            ; test EAX,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 0F7h, 0C3h      ; test EBX,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 0F7h, 0C1h      ; test ECX,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 0F7h, 0C2h      ; test EDX,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 0F7h, 0C6h      ; test ESI,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 0F7h, 0C7h      ; test EDI,12345678h
instr2 40h MODF_EBP+MODF_FLAGS  DB 0F7h, 0C5h      ; test EBP,12345678h

iimm32end    LABEL BYTE

instr2 10h MODF_EAX  DB 0B0h           ; mov AL,12h
instr2 10h MODF_EAX  DB 0B4h           ; mov AH,12h
instr2 10h MODF_EBX  DB 0B3h           ; mov BL,12h
instr2 10h MODF_EBX  DB 0B7h           ; mov BH,12h
instr2 10h MODF_ECX  DB 0B1h           ; mov CL,12h
instr2 10h MODF_ECX  DB 0B5h           ; mov CH,12h
instr2 10h MODF_EDX  DB 0B2h           ; mov DL,12h
instr2 10h MODF_EDX  DB 0B6h           ; mov DH,12h

instr2 10h MODF_EAX  DB 004h           ; add AL,12h
instr2 10h MODF_EAX  DB 080h, 0C4h     ; add AH,12h
instr2 10h MODF_EBX  DB 080h, 0C3h     ; add BL,12h
instr2 10h MODF_EBX  DB 080h, 0C7h     ; add BH,12h
instr2 10h MODF_ECX  DB 080h, 0C1h     ; add CL,12h
instr2 10h MODF_ECX  DB 080h, 0C5h     ; add CH,12h
instr2 10h MODF_EDX  DB 080h, 0C2h     ; add DL,12h
instr2 10h MODF_EDX  DB 080h, 0C6h     ; add DH,12h

instr2 10h MODF_EAX  DB 02Ch            ; sub AL,12h
instr2 10h MODF_EAX  DB 080h, 0ECh      ; sub AH,12h
instr2 10h MODF_EBX  DB 080h, 0EBh      ; sub BL,12h
instr2 10h MODF_EBX  DB 080h, 0EFh      ; sub BH,12h
instr2 10h MODF_ECX  DB 080h, 0E9h      ; sub CL,12h
instr2 10h MODF_ECX  DB 080h, 0EDh      ; sub CH,12h
instr2 10h MODF_EDX  DB 080h, 0EAh      ; sub DL,12h
instr2 10h MODF_EDX  DB 080h, 0EEh      ; sub DH,12h

instr2 10h MODF_EAX  DB 024h            ; and AL,12h
instr2 10h MODF_EAX  DB 080h, 0E4h      ; and AH,12h
instr2 10h MODF_EBX  DB 080h, 0E3h      ; and BL,12h
instr2 10h MODF_EBX  DB 080h, 0E7h      ; and BH,12h
instr2 10h MODF_ECX  DB 080h, 0E1h      ; and CL,12h
instr2 10h MODF_ECX  DB 080h, 0E5h      ; and CH,12h
instr2 10h MODF_EDX  DB 080h, 0E2h      ; and DL,12h
instr2 10h MODF_EDX  DB 080h, 0E6h      ; and DH,12h

instr2 10h MODF_EAX  DB 00Ch            ; or AL,12h
instr2 10h MODF_EAX  DB 080h, 0CCh      ; or AH,12h
instr2 10h MODF_EBX  DB 080h, 0CBh      ; or BL,12h
instr2 10h MODF_EBX  DB 080h, 0CFh      ; or BH,12h
instr2 10h MODF_ECX  DB 080h, 0C9h      ; or CL,12h
instr2 10h MODF_ECX  DB 080h, 0CDh      ; or CH,12h
instr2 10h MODF_EDX  DB 080h, 0CAh      ; or DL,12h
instr2 10h MODF_EDX  DB 080h, 0CEh      ; or DH,12h

instr2 10h MODF_EAX  DB 034h            ; xor AL,12h
instr2 10h MODF_EAX  DB 080h, 0F4h      ; xor AH,12h
instr2 10h MODF_EBX  DB 080h, 0F3h      ; xor BL,12h
instr2 10h MODF_EBX  DB 080h, 0F7h      ; xor BH,12h
instr2 10h MODF_ECX  DB 080h, 0F1h      ; xor CL,12h
instr2 10h MODF_ECX  DB 080h, 0F5h      ; xor CH,12h
instr2 10h MODF_EDX  DB 080h, 0F2h      ; xor DL,12h
instr2 10h MODF_EDX  DB 080h, 0F6h      ; xor DH,12h

instr2 10h MODF_EAX  DB 0A8h            ; test AL,12h
instr2 10h MODF_EAX  DB 0F6h, 0C4h      ; test AH,12h
instr2 10h MODF_EBX  DB 0F6h, 0C3h      ; test BL,12h
instr2 10h MODF_EBX  DB 0F6h, 0C7h      ; test BH,12h
instr2 10h MODF_ECX  DB 0F6h, 0C1h      ; test CL,12h
instr2 10h MODF_ECX  DB 0F6h, 0C5h      ; test CH,12h
instr2 10h MODF_EDX  DB 0F6h, 0C2h      ; test DL,12h
instr2 10h MODF_EDX  DB 0F6h, 0C6h      ; test DH,12h

instr2 90h MODF_EAX+MODF_FLAGS  DB 0C1h, 0E0h      ; shl EAX,8h
instr2 90h MODF_EBX+MODF_FLAGS  DB 0C1h, 0E3h      ; shl EBX,8h
instr2 90h MODF_ECX+MODF_FLAGS  DB 0C1h, 0E1h      ; shl ECX,8h
instr2 90h MODF_EDX+MODF_FLAGS  DB 0C1h, 0E2h      ; shl EDX,8h
instr2 90h MODF_ESI+MODF_FLAGS  DB 0C1h, 0E6h      ; shl ESI,8h
instr2 90h MODF_EDI+MODF_FLAGS  DB 0C1h, 0E7h      ; shl EDI,8h
instr2 90h MODF_EBP+MODF_FLAGS  DB 0C1h, 0E5h      ; shl EBP,8h

instr2 90h MODF_EAX+MODF_FLAGS  DB 0C1h, 0E8h      ; shr EAX,8h
instr2 90h MODF_EBX+MODF_FLAGS  DB 0C1h, 0EBh      ; shr EBX,8h
instr2 90h MODF_ECX+MODF_FLAGS  DB 0C1h, 0E9h      ; shr ECX,8h
instr2 90h MODF_EDX+MODF_FLAGS  DB 0C1h, 0EAh      ; shr EDX,8h
instr2 90h MODF_ESI+MODF_FLAGS  DB 0C1h, 0EEh      ; shr ESI,8h
instr2 90h MODF_EDI+MODF_FLAGS  DB 0C1h, 0EFh      ; shr EDI,8h
instr2 90h MODF_EBP+MODF_FLAGS  DB 0C1h, 0EDh      ; shr EBP,8h

iimm8end     LABEL BYTE

inst MODF_EAX        mov   EAX,ESP
inst MODF_EBX        mov   EBX,ESP
inst MODF_ECX        mov   ECX,ESP
inst MODF_EDX        mov   EDX,ESP
inst MODF_ESI        mov   ESI,ESP
inst MODF_EDI        mov   EDI,ESP
inst MODF_EBP        mov   EBP,ESP

inst MODF_EAX+MODF_FLAGS       add   EAX,ESP
inst MODF_EBX+MODF_FLAGS       add   EBX,ESP
inst MODF_ECX+MODF_FLAGS       add   ECX,ESP
inst MODF_EDX+MODF_FLAGS       add   EDX,ESP
inst MODF_ESI+MODF_FLAGS       add   ESI,ESP
inst MODF_EDI+MODF_FLAGS       add   EDI,ESP
inst MODF_EBP+MODF_FLAGS       add   EBP,ESP

inst MODF_EAX+MODF_FLAGS       sub   EAX,ESP
inst MODF_EBX+MODF_FLAGS       sub   EBX,ESP
inst MODF_ECX+MODF_FLAGS       sub   ECX,ESP
inst MODF_EDX+MODF_FLAGS       sub   EDX,ESP
inst MODF_ESI+MODF_FLAGS       sub   ESI,ESP
inst MODF_EDI+MODF_FLAGS       sub   EDI,ESP
inst MODF_EBP+MODF_FLAGS       sub   EBP,ESP


inst MODF_EAX+MODF_FLAGS       aaa
inst MODF_EAX+MODF_FLAGS       aad
inst MODF_EAX+MODF_FLAGS       aam
inst MODF_EAX+MODF_FLAGS       aas
inst MODF_EAX+MODF_FLAGS       daa
inst MODF_EAX+MODF_FLAGS       das
inst MODF_EAX+MODF_FLAGS       cwde
inst MODF_EAX+MODF_FLAGS       lahf
inst MODF_FLAGS                sahf
inst MODF_FLAGS                clc
inst MODF_FLAGS                stc
inst MODF_FLAGS                cmc
inst MODF_FLAGS                cld
inst MODF_FLAGS                std
inst MODF_EAX+MODF_EDX+MODF_FLAGS       cdq

inst MODF_EAX+MODF_FLAGS       inc   EAX
inst MODF_EBX+MODF_FLAGS       inc   EBX
inst MODF_ECX+MODF_FLAGS       inc   ECX
inst MODF_EDX+MODF_FLAGS       inc   EDX
inst MODF_ESI+MODF_FLAGS       inc   ESI
inst MODF_EDI+MODF_FLAGS       inc   EDI
inst MODF_EBP+MODF_FLAGS       inc   EBP

inst MODF_EAX+MODF_FLAGS       dec   EAX
inst MODF_EBX+MODF_FLAGS       dec   EBX
inst MODF_ECX+MODF_FLAGS       dec   ECX
inst MODF_EDX+MODF_FLAGS       dec   EDX
inst MODF_ESI+MODF_FLAGS       dec   ESI
inst MODF_EDI+MODF_FLAGS       dec   EDI
inst MODF_EBP+MODF_FLAGS       dec   EBP

imiscend     LABEL BYTE


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; mov EAX,XXX
;
inst MODF_EAX        mov   EAX,EBX
inst MODF_EAX        mov   EAX,EDX
inst MODF_EAX        mov   EAX,ECX
inst MODF_EAX        mov   EAX,ESI
inst MODF_EAX        mov   EAX,EDI
inst MODF_EAX        mov   EAX,EBP
inst MODF_EAX        mov   AL,AH
inst MODF_EAX        mov   AL,BL
inst MODF_EAX        mov   AL,BH
inst MODF_EAX        mov   AL,CL
inst MODF_EAX        mov   AL,CH
inst MODF_EAX        mov   AL,DL
inst MODF_EAX        mov   AL,DH
inst MODF_EAX        movzx EAX,BX
inst MODF_EAX        movzx EAX,CX
inst MODF_EAX        movzx EAX,DX
inst MODF_EAX        movsx EAX,BX
inst MODF_EAX        movsx EAX,CX
inst MODF_EAX        movsx EAX,DX
inst MODF_EAX        mov   AH,AL
inst MODF_EAX        mov   AH,BL
inst MODF_EAX        mov   AH,BH
inst MODF_EAX        mov   AH,CL
inst MODF_EAX        mov   AH,CH
inst MODF_EAX        mov   AH,DL
inst MODF_EAX        mov   AH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; mov EBX,XXX
;
inst MODF_EBX        mov   EBX,EAX
inst MODF_EBX        mov   EBX,EDX
inst MODF_EBX        mov   EBX,ECX
inst MODF_EBX        mov   EBX,ESI
inst MODF_EBX        mov   EBX,EDI
inst MODF_EBX        mov   EBX,EBP
inst MODF_EBX        mov   BL,AL
inst MODF_EBX        mov   BL,AH
inst MODF_EBX        mov   BL,BH
inst MODF_EBX        mov   BL,CL
inst MODF_EBX        mov   BL,CH
inst MODF_EBX        mov   BL,DL
inst MODF_EBX        mov   BL,DH
inst MODF_EBX        movzx EBX,AX
inst MODF_EBX        movzx EBX,CX
inst MODF_EBX        movzx EBX,DX
inst MODF_EBX        movsx EBX,AX
inst MODF_EBX        movsx EBX,CX
inst MODF_EBX        movsx EBX,DX
inst MODF_EBX        mov   BH,AL
inst MODF_EBX        mov   BH,AH
inst MODF_EBX        mov   BH,BL
inst MODF_EBX        mov   BH,CL
inst MODF_EBX        mov   BH,CH
inst MODF_EBX        mov   BH,DL
inst MODF_EBX        mov   BH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; mov ECX,XXX
;
inst MODF_ECX        mov   ECX,EAX
inst MODF_ECX        mov   ECX,EBX
inst MODF_ECX        mov   ECX,EDX
inst MODF_ECX        mov   ECX,ESI
inst MODF_ECX        mov   ECX,EDI
inst MODF_ECX        mov   ECX,EBP
inst MODF_ECX        mov   CL,AL
inst MODF_ECX        mov   CL,AH
inst MODF_ECX        mov   CL,BL
inst MODF_ECX        mov   CL,BH
inst MODF_ECX        mov   CL,CH
inst MODF_ECX        mov   CL,DL
inst MODF_ECX        mov   CL,DH
inst MODF_ECX        movzx ECX,AX
inst MODF_ECX        movzx ECX,BX
inst MODF_ECX        movzx ECX,DX
inst MODF_ECX        movsx ECX,AX
inst MODF_ECX        movsx ECX,BX
inst MODF_ECX        movsx ECX,DX
inst MODF_ECX        mov   CH,AL
inst MODF_ECX        mov   CH,AH
inst MODF_ECX        mov   CH,BL
inst MODF_ECX        mov   CH,BH
inst MODF_ECX        mov   CH,CL
inst MODF_ECX        mov   CH,DL
inst MODF_ECX        mov   CH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; mov EDX,XXX
;
inst MODF_EDX        mov   EDX,EAX
inst MODF_EDX        mov   EDX,EBX
inst MODF_EDX        mov   EDX,ECX
inst MODF_EDX        mov   EDX,ESI
inst MODF_EDX        mov   EDX,EDI
inst MODF_EDX        mov   EDX,EBP
inst MODF_EDX        mov   DL,AL
inst MODF_EDX        mov   DL,AH
inst MODF_EDX        mov   DL,BL
inst MODF_EDX        mov   DL,BH
inst MODF_EDX        mov   DL,CL
inst MODF_EDX        mov   DL,CH
inst MODF_EDX        mov   DL,DH
inst MODF_EDX        movzx EDX,AX
inst MODF_EDX        movzx EDX,BX
inst MODF_EDX        movzx EDX,CX
inst MODF_EDX        movsx EDX,AX
inst MODF_EDX        movsx EDX,BX
inst MODF_EDX        movsx EDX,CX
inst MODF_EDX        mov   DH,AL
inst MODF_EDX        mov   DH,AH
inst MODF_EDX        mov   DH,BL
inst MODF_EDX        mov   DH,BH
inst MODF_EDX        mov   DH,CL
inst MODF_EDX        mov   DH,CH
inst MODF_EDX        mov   DH,DL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; mov ESI,XXX
;
inst MODF_ESI        mov   ESI,EAX
inst MODF_ESI        mov   ESI,EBX
inst MODF_ESI        mov   ESI,ECX
inst MODF_ESI        mov   ESI,EDX
inst MODF_ESI        mov   ESI,EDI
inst MODF_ESI        mov   ESI,EBP
inst MODF_ESI        movzx ESI,AX
inst MODF_ESI        movzx ESI,BX
inst MODF_ESI        movzx ESI,CX
inst MODF_ESI        movzx ESI,DX
inst MODF_ESI        movsx ESI,AX
inst MODF_ESI        movsx ESI,BX
inst MODF_ESI        movsx ESI,CX
inst MODF_ESI        movsx ESI,DX

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; mov EDI,XXX
;
inst MODF_EDI        mov   EDI,EAX
inst MODF_EDI        mov   EDI,EBX
inst MODF_EDI        mov   EDI,ECX
inst MODF_EDI        mov   EDI,EDX
inst MODF_EDI        mov   EDI,ESI
inst MODF_EDI        mov   EDI,EBP
inst MODF_EDI        movzx EDI,AX
inst MODF_EDI        movzx EDI,BX
inst MODF_EDI        movzx EDI,CX
inst MODF_EDI        movzx EDI,DX
inst MODF_EDI        movsx EDI,AX
inst MODF_EDI        movsx EDI,BX
inst MODF_EDI        movsx EDI,CX
inst MODF_EDI        movsx EDI,DX

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; mov EBP,XXX
;
inst MODF_EBP        mov   EBP,EAX
inst MODF_EBP        mov   EBP,EBX
inst MODF_EBP        mov   EBP,ECX
inst MODF_EBP        mov   EBP,EDX
inst MODF_EBP        mov   EBP,ESI
inst MODF_EBP        mov   EBP,EDI
inst MODF_EBP        movzx EBP,AX
inst MODF_EBP        movzx EBP,BX
inst MODF_EBP        movzx EBP,CX
inst MODF_EBP        movzx EBP,DX
inst MODF_EBP        movsx EBP,AX
inst MODF_EBP        movsx EBP,BX
inst MODF_EBP        movsx EBP,CX
inst MODF_EBP        movsx EBP,DX


;----------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; add EAX,XXX
;
inst MODF_EAX+MODF_FLAGS        add   EAX,EBX
inst MODF_EAX+MODF_FLAGS        add   EAX,EDX
inst MODF_EAX+MODF_FLAGS        add   EAX,ECX
inst MODF_EAX+MODF_FLAGS        add   EAX,ESI
inst MODF_EAX+MODF_FLAGS        add   EAX,EDI
inst MODF_EAX+MODF_FLAGS        add   EAX,EBP
inst MODF_EAX+MODF_FLAGS        add   AL,AH
inst MODF_EAX+MODF_FLAGS        add   AL,BL
inst MODF_EAX+MODF_FLAGS        add   AL,BH
inst MODF_EAX+MODF_FLAGS        add   AL,CL
inst MODF_EAX+MODF_FLAGS        add   AL,CH
inst MODF_EAX+MODF_FLAGS        add   AL,DL
inst MODF_EAX+MODF_FLAGS        add   AL,DH
inst MODF_EAX+MODF_FLAGS        add   AH,AL
inst MODF_EAX+MODF_FLAGS        add   AH,BL
inst MODF_EAX+MODF_FLAGS        add   AH,BH
inst MODF_EAX+MODF_FLAGS        add   AH,CL
inst MODF_EAX+MODF_FLAGS        add   AH,CH
inst MODF_EAX+MODF_FLAGS        add   AH,DL
inst MODF_EAX+MODF_FLAGS        add   AH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; add EBX,XXX
;
inst MODF_EBX+MODF_FLAGS        add   EBX,EAX
inst MODF_EBX+MODF_FLAGS        add   EBX,EDX
inst MODF_EBX+MODF_FLAGS        add   EBX,ECX
inst MODF_EBX+MODF_FLAGS        add   EBX,ESI
inst MODF_EBX+MODF_FLAGS        add   EBX,EDI
inst MODF_EBX+MODF_FLAGS        add   EBX,EBP
inst MODF_EBX+MODF_FLAGS        add   BL,AL
inst MODF_EBX+MODF_FLAGS        add   BL,AH
inst MODF_EBX+MODF_FLAGS        add   BL,BH
inst MODF_EBX+MODF_FLAGS        add   BL,CL
inst MODF_EBX+MODF_FLAGS        add   BL,CH
inst MODF_EBX+MODF_FLAGS        add   BL,DL
inst MODF_EBX+MODF_FLAGS        add   BL,DH
inst MODF_EBX+MODF_FLAGS        add   BH,AL
inst MODF_EBX+MODF_FLAGS        add   BH,AH
inst MODF_EBX+MODF_FLAGS        add   BH,BL
inst MODF_EBX+MODF_FLAGS        add   BH,CL
inst MODF_EBX+MODF_FLAGS        add   BH,CH
inst MODF_EBX+MODF_FLAGS        add   BH,DL
inst MODF_EBX+MODF_FLAGS        add   BH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; add ECX,XXX
;
inst MODF_ECX+MODF_FLAGS        add   ECX,EAX
inst MODF_ECX+MODF_FLAGS        add   ECX,EBX
inst MODF_ECX+MODF_FLAGS        add   ECX,EDX
inst MODF_ECX+MODF_FLAGS        add   ECX,ESI
inst MODF_ECX+MODF_FLAGS        add   ECX,EDI
inst MODF_ECX+MODF_FLAGS        add   ECX,EBP
inst MODF_ECX+MODF_FLAGS        add   CL,AL
inst MODF_ECX+MODF_FLAGS        add   CL,AH
inst MODF_ECX+MODF_FLAGS        add   CL,BL
inst MODF_ECX+MODF_FLAGS        add   CL,BH
inst MODF_ECX+MODF_FLAGS        add   CL,CH
inst MODF_ECX+MODF_FLAGS        add   CL,DL
inst MODF_ECX+MODF_FLAGS        add   CL,DH
inst MODF_ECX+MODF_FLAGS        add   CH,AL
inst MODF_ECX+MODF_FLAGS        add   CH,AH
inst MODF_ECX+MODF_FLAGS        add   CH,BL
inst MODF_ECX+MODF_FLAGS        add   CH,BH
inst MODF_ECX+MODF_FLAGS        add   CH,CL
inst MODF_ECX+MODF_FLAGS        add   CH,DL
inst MODF_ECX+MODF_FLAGS        add   CH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; add EDX,XXX
;
inst MODF_EDX+MODF_FLAGS        add   EDX,EAX
inst MODF_EDX+MODF_FLAGS        add   EDX,EBX
inst MODF_EDX+MODF_FLAGS        add   EDX,ECX
inst MODF_EDX+MODF_FLAGS        add   EDX,ESI
inst MODF_EDX+MODF_FLAGS        add   EDX,EDI
inst MODF_EDX+MODF_FLAGS        add   EDX,EBP
inst MODF_EDX+MODF_FLAGS        add   DL,AL
inst MODF_EDX+MODF_FLAGS        add   DL,AH
inst MODF_EDX+MODF_FLAGS        add   DL,BL
inst MODF_EDX+MODF_FLAGS        add   DL,BH
inst MODF_EDX+MODF_FLAGS        add   DL,CL
inst MODF_EDX+MODF_FLAGS        add   DL,CH
inst MODF_EDX+MODF_FLAGS        add   DL,DH
inst MODF_EDX+MODF_FLAGS        add   DH,AL
inst MODF_EDX+MODF_FLAGS        add   DH,AH
inst MODF_EDX+MODF_FLAGS        add   DH,BL
inst MODF_EDX+MODF_FLAGS        add   DH,BH
inst MODF_EDX+MODF_FLAGS        add   DH,CL
inst MODF_EDX+MODF_FLAGS        add   DH,CH
inst MODF_EDX+MODF_FLAGS        add   DH,DL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; add ESI,XXX
;
inst MODF_ESI+MODF_FLAGS        add   ESI,EAX
inst MODF_ESI+MODF_FLAGS        add   ESI,EBX
inst MODF_ESI+MODF_FLAGS        add   ESI,ECX
inst MODF_ESI+MODF_FLAGS        add   ESI,EDX
inst MODF_ESI+MODF_FLAGS        add   ESI,EDI
inst MODF_ESI+MODF_FLAGS        add   ESI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; add EDI,XXX
;
inst MODF_EDI+MODF_FLAGS        add   EDI,EAX
inst MODF_EDI+MODF_FLAGS        add   EDI,EBX
inst MODF_EDI+MODF_FLAGS        add   EDI,ECX
inst MODF_EDI+MODF_FLAGS        add   EDI,EDX
inst MODF_EDI+MODF_FLAGS        add   EDI,ESI
inst MODF_EDI+MODF_FLAGS        add   EDI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; add EBP,XXX
;
inst MODF_EBP+MODF_FLAGS        add   EBP,EAX
inst MODF_EBP+MODF_FLAGS        add   EBP,EBX
inst MODF_EBP+MODF_FLAGS        add   EBP,ECX
inst MODF_EBP+MODF_FLAGS        add   EBP,EDX
inst MODF_EBP+MODF_FLAGS        add   EBP,ESI
inst MODF_EBP+MODF_FLAGS        add   EBP,EDI


;----------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; adc EAX,XXX
;
inst MODF_EAX+MODF_FLAGS        adc   EAX,EBX
inst MODF_EAX+MODF_FLAGS        adc   EAX,EDX
inst MODF_EAX+MODF_FLAGS        adc   EAX,ECX
inst MODF_EAX+MODF_FLAGS        adc   EAX,ESI
inst MODF_EAX+MODF_FLAGS        adc   EAX,EDI
inst MODF_EAX+MODF_FLAGS        adc   EAX,EBP
inst MODF_EAX+MODF_FLAGS        adc   AL,AH
inst MODF_EAX+MODF_FLAGS        adc   AL,BL
inst MODF_EAX+MODF_FLAGS        adc   AL,BH
inst MODF_EAX+MODF_FLAGS        adc   AL,CL
inst MODF_EAX+MODF_FLAGS        adc   AL,CH
inst MODF_EAX+MODF_FLAGS        adc   AL,DL
inst MODF_EAX+MODF_FLAGS        adc   AL,DH
inst MODF_EAX+MODF_FLAGS        adc   AH,AL
inst MODF_EAX+MODF_FLAGS        adc   AH,BL
inst MODF_EAX+MODF_FLAGS        adc   AH,BH
inst MODF_EAX+MODF_FLAGS        adc   AH,CL
inst MODF_EAX+MODF_FLAGS        adc   AH,CH
inst MODF_EAX+MODF_FLAGS        adc   AH,DL
inst MODF_EAX+MODF_FLAGS        adc   AH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; adc EBX,XXX
;
inst MODF_EBX+MODF_FLAGS        adc   EBX,EAX
inst MODF_EBX+MODF_FLAGS        adc   EBX,EDX
inst MODF_EBX+MODF_FLAGS        adc   EBX,ECX
inst MODF_EBX+MODF_FLAGS        adc   EBX,ESI
inst MODF_EBX+MODF_FLAGS        adc   EBX,EDI
inst MODF_EBX+MODF_FLAGS        adc   EBX,EBP
inst MODF_EBX+MODF_FLAGS        adc   BL,AL
inst MODF_EBX+MODF_FLAGS        adc   BL,AH
inst MODF_EBX+MODF_FLAGS        adc   BL,BH
inst MODF_EBX+MODF_FLAGS        adc   BL,CL
inst MODF_EBX+MODF_FLAGS        adc   BL,CH
inst MODF_EBX+MODF_FLAGS        adc   BL,DL
inst MODF_EBX+MODF_FLAGS        adc   BL,DH
inst MODF_EBX+MODF_FLAGS        adc   BH,AL
inst MODF_EBX+MODF_FLAGS        adc   BH,AH
inst MODF_EBX+MODF_FLAGS        adc   BH,BL
inst MODF_EBX+MODF_FLAGS        adc   BH,CL
inst MODF_EBX+MODF_FLAGS        adc   BH,CH
inst MODF_EBX+MODF_FLAGS        adc   BH,DL
inst MODF_EBX+MODF_FLAGS        adc   BH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; adc ECX,XXX
;
inst MODF_ECX+MODF_FLAGS        adc   ECX,EAX
inst MODF_ECX+MODF_FLAGS        adc   ECX,EBX
inst MODF_ECX+MODF_FLAGS        adc   ECX,EDX
inst MODF_ECX+MODF_FLAGS        adc   ECX,ESI
inst MODF_ECX+MODF_FLAGS        adc   ECX,EDI
inst MODF_ECX+MODF_FLAGS        adc   ECX,EBP
inst MODF_ECX+MODF_FLAGS        adc   CL,AL
inst MODF_ECX+MODF_FLAGS        adc   CL,AH
inst MODF_ECX+MODF_FLAGS        adc   CL,BL
inst MODF_ECX+MODF_FLAGS        adc   CL,BH
inst MODF_ECX+MODF_FLAGS        adc   CL,CH
inst MODF_ECX+MODF_FLAGS        adc   CL,DL
inst MODF_ECX+MODF_FLAGS        adc   CL,DH
inst MODF_ECX+MODF_FLAGS        adc   CH,AL
inst MODF_ECX+MODF_FLAGS        adc   CH,AH
inst MODF_ECX+MODF_FLAGS        adc   CH,BL
inst MODF_ECX+MODF_FLAGS        adc   CH,BH
inst MODF_ECX+MODF_FLAGS        adc   CH,CL
inst MODF_ECX+MODF_FLAGS        adc   CH,DL
inst MODF_ECX+MODF_FLAGS        adc   CH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; adc EDX,XXX
;
inst MODF_EDX+MODF_FLAGS        adc   EDX,EAX
inst MODF_EDX+MODF_FLAGS        adc   EDX,EBX
inst MODF_EDX+MODF_FLAGS        adc   EDX,ECX
inst MODF_EDX+MODF_FLAGS        adc   EDX,ESI
inst MODF_EDX+MODF_FLAGS        adc   EDX,EDI
inst MODF_EDX+MODF_FLAGS        adc   EDX,EBP
inst MODF_EDX+MODF_FLAGS        adc   DL,AL
inst MODF_EDX+MODF_FLAGS        adc   DL,AH
inst MODF_EDX+MODF_FLAGS        adc   DL,BL
inst MODF_EDX+MODF_FLAGS        adc   DL,BH
inst MODF_EDX+MODF_FLAGS        adc   DL,CL
inst MODF_EDX+MODF_FLAGS        adc   DL,CH
inst MODF_EDX+MODF_FLAGS        adc   DL,DH
inst MODF_EDX+MODF_FLAGS        adc   DH,AL
inst MODF_EDX+MODF_FLAGS        adc   DH,AH
inst MODF_EDX+MODF_FLAGS        adc   DH,BL
inst MODF_EDX+MODF_FLAGS        adc   DH,BH
inst MODF_EDX+MODF_FLAGS        adc   DH,CL
inst MODF_EDX+MODF_FLAGS        adc   DH,CH
inst MODF_EDX+MODF_FLAGS        adc   DH,DL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; adc ESI,XXX
;
inst MODF_ESI+MODF_FLAGS        adc   ESI,EAX
inst MODF_ESI+MODF_FLAGS        adc   ESI,EBX
inst MODF_ESI+MODF_FLAGS        adc   ESI,ECX
inst MODF_ESI+MODF_FLAGS        adc   ESI,EDX
inst MODF_ESI+MODF_FLAGS        adc   ESI,EDI
inst MODF_ESI+MODF_FLAGS        adc   ESI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; adc EDI,XXX
;
inst MODF_EDI+MODF_FLAGS        adc   EDI,EAX
inst MODF_EDI+MODF_FLAGS        adc   EDI,EBX
inst MODF_EDI+MODF_FLAGS        adc   EDI,ECX
inst MODF_EDI+MODF_FLAGS        adc   EDI,EDX
inst MODF_EDI+MODF_FLAGS        adc   EDI,ESI
inst MODF_EDI+MODF_FLAGS        adc   EDI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; adc EBP,XXX
;
inst MODF_EBP+MODF_FLAGS        adc   EBP,EAX
inst MODF_EBP+MODF_FLAGS        adc   EBP,EBX
inst MODF_EBP+MODF_FLAGS        adc   EBP,ECX
inst MODF_EBP+MODF_FLAGS        adc   EBP,EDX
inst MODF_EBP+MODF_FLAGS        adc   EBP,ESI
inst MODF_EBP+MODF_FLAGS        adc   EBP,EDI



;----------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sub EAX,XXX
;
inst MODF_EAX+MODF_FLAGS        sub   EAX,EBX
inst MODF_EAX+MODF_FLAGS        sub   EAX,EDX
inst MODF_EAX+MODF_FLAGS        sub   EAX,ECX
inst MODF_EAX+MODF_FLAGS        sub   EAX,ESI
inst MODF_EAX+MODF_FLAGS        sub   EAX,EDI
inst MODF_EAX+MODF_FLAGS        sub   EAX,EBP
inst MODF_EAX+MODF_FLAGS        sub   AL,AH
inst MODF_EAX+MODF_FLAGS        sub   AL,BL
inst MODF_EAX+MODF_FLAGS        sub   AL,BH
inst MODF_EAX+MODF_FLAGS        sub   AL,CL
inst MODF_EAX+MODF_FLAGS        sub   AL,CH
inst MODF_EAX+MODF_FLAGS        sub   AL,DL
inst MODF_EAX+MODF_FLAGS        sub   AL,DH
inst MODF_EAX+MODF_FLAGS        sub   AH,AL
inst MODF_EAX+MODF_FLAGS        sub   AH,BL
inst MODF_EAX+MODF_FLAGS        sub   AH,BH
inst MODF_EAX+MODF_FLAGS        sub   AH,CL
inst MODF_EAX+MODF_FLAGS        sub   AH,CH
inst MODF_EAX+MODF_FLAGS        sub   AH,DL
inst MODF_EAX+MODF_FLAGS        sub   AH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sub EBX,XXX
;
inst MODF_EBX+MODF_FLAGS        sub   EBX,EAX
inst MODF_EBX+MODF_FLAGS        sub   EBX,EDX
inst MODF_EBX+MODF_FLAGS        sub   EBX,ECX
inst MODF_EBX+MODF_FLAGS        sub   EBX,ESI
inst MODF_EBX+MODF_FLAGS        sub   EBX,EDI
inst MODF_EBX+MODF_FLAGS        sub   EBX,EBP
inst MODF_EBX+MODF_FLAGS        sub   BL,AL
inst MODF_EBX+MODF_FLAGS        sub   BL,AH
inst MODF_EBX+MODF_FLAGS        sub   BL,BH
inst MODF_EBX+MODF_FLAGS        sub   BL,CL
inst MODF_EBX+MODF_FLAGS        sub   BL,CH
inst MODF_EBX+MODF_FLAGS        sub   BL,DL
inst MODF_EBX+MODF_FLAGS        sub   BL,DH
inst MODF_EBX+MODF_FLAGS        sub   BH,AL
inst MODF_EBX+MODF_FLAGS        sub   BH,AH
inst MODF_EBX+MODF_FLAGS        sub   BH,BL
inst MODF_EBX+MODF_FLAGS        sub   BH,CL
inst MODF_EBX+MODF_FLAGS        sub   BH,CH
inst MODF_EBX+MODF_FLAGS        sub   BH,DL
inst MODF_EBX+MODF_FLAGS        sub   BH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sub ECX,XXX
;
inst MODF_ECX+MODF_FLAGS        sub   ECX,EAX
inst MODF_ECX+MODF_FLAGS        sub   ECX,EBX
inst MODF_ECX+MODF_FLAGS        sub   ECX,EDX
inst MODF_ECX+MODF_FLAGS        sub   ECX,ESI
inst MODF_ECX+MODF_FLAGS        sub   ECX,EDI
inst MODF_ECX+MODF_FLAGS        sub   ECX,EBP
inst MODF_ECX+MODF_FLAGS        sub   CL,AL
inst MODF_ECX+MODF_FLAGS        sub   CL,AH
inst MODF_ECX+MODF_FLAGS        sub   CL,BL
inst MODF_ECX+MODF_FLAGS        sub   CL,BH
inst MODF_ECX+MODF_FLAGS        sub   CL,CH
inst MODF_ECX+MODF_FLAGS        sub   CL,DL
inst MODF_ECX+MODF_FLAGS        sub   CL,DH
inst MODF_ECX+MODF_FLAGS        sub   CH,AL
inst MODF_ECX+MODF_FLAGS        sub   CH,AH
inst MODF_ECX+MODF_FLAGS        sub   CH,BL
inst MODF_ECX+MODF_FLAGS        sub   CH,BH
inst MODF_ECX+MODF_FLAGS        sub   CH,CL
inst MODF_ECX+MODF_FLAGS        sub   CH,DL
inst MODF_ECX+MODF_FLAGS        sub   CH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sub EDX,XXX
;
inst MODF_EDX+MODF_FLAGS        sub   EDX,EAX
inst MODF_EDX+MODF_FLAGS        sub   EDX,EBX
inst MODF_EDX+MODF_FLAGS        sub   EDX,ECX
inst MODF_EDX+MODF_FLAGS        sub   EDX,ESI
inst MODF_EDX+MODF_FLAGS        sub   EDX,EDI
inst MODF_EDX+MODF_FLAGS        sub   EDX,EBP
inst MODF_EDX+MODF_FLAGS        sub   DL,AL
inst MODF_EDX+MODF_FLAGS        sub   DL,AH
inst MODF_EDX+MODF_FLAGS        sub   DL,BL
inst MODF_EDX+MODF_FLAGS        sub   DL,BH
inst MODF_EDX+MODF_FLAGS        sub   DL,CL
inst MODF_EDX+MODF_FLAGS        sub   DL,CH
inst MODF_EDX+MODF_FLAGS        sub   DL,DH
inst MODF_EDX+MODF_FLAGS        sub   DH,AL
inst MODF_EDX+MODF_FLAGS        sub   DH,AH
inst MODF_EDX+MODF_FLAGS        sub   DH,BL
inst MODF_EDX+MODF_FLAGS        sub   DH,BH
inst MODF_EDX+MODF_FLAGS        sub   DH,CL
inst MODF_EDX+MODF_FLAGS        sub   DH,CH
inst MODF_EDX+MODF_FLAGS        sub   DH,DL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sub ESI,XXX
;
inst MODF_ESI+MODF_FLAGS        sub   ESI,EAX
inst MODF_ESI+MODF_FLAGS        sub   ESI,EBX
inst MODF_ESI+MODF_FLAGS        sub   ESI,ECX
inst MODF_ESI+MODF_FLAGS        sub   ESI,EDX
inst MODF_ESI+MODF_FLAGS        sub   ESI,EDI
inst MODF_ESI+MODF_FLAGS        sub   ESI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sub EDI,XXX
;
inst MODF_EDI+MODF_FLAGS        sub   EDI,EAX
inst MODF_EDI+MODF_FLAGS        sub   EDI,EBX
inst MODF_EDI+MODF_FLAGS        sub   EDI,ECX
inst MODF_EDI+MODF_FLAGS        sub   EDI,EDX
inst MODF_EDI+MODF_FLAGS        sub   EDI,ESI
inst MODF_EDI+MODF_FLAGS        sub   EDI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sub EBP,XXX
;
inst MODF_EBP+MODF_FLAGS        sub   EBP,EAX
inst MODF_EBP+MODF_FLAGS        sub   EBP,EBX
inst MODF_EBP+MODF_FLAGS        sub   EBP,ECX
inst MODF_EBP+MODF_FLAGS        sub   EBP,EDX
inst MODF_EBP+MODF_FLAGS        sub   EBP,ESI
inst MODF_EBP+MODF_FLAGS        sub   EBP,EDI


;----------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sbb EAX,XXX
;
inst MODF_EAX+MODF_FLAGS        sbb   EAX,EBX
inst MODF_EAX+MODF_FLAGS        sbb   EAX,EDX
inst MODF_EAX+MODF_FLAGS        sbb   EAX,ECX
inst MODF_EAX+MODF_FLAGS        sbb   EAX,ESI
inst MODF_EAX+MODF_FLAGS        sbb   EAX,EDI
inst MODF_EAX+MODF_FLAGS        sbb   EAX,EBP
inst MODF_EAX+MODF_FLAGS        sbb   AL,AH
inst MODF_EAX+MODF_FLAGS        sbb   AL,BL
inst MODF_EAX+MODF_FLAGS        sbb   AL,BH
inst MODF_EAX+MODF_FLAGS        sbb   AL,CL
inst MODF_EAX+MODF_FLAGS        sbb   AL,CH
inst MODF_EAX+MODF_FLAGS        sbb   AL,DL
inst MODF_EAX+MODF_FLAGS        sbb   AL,DH
inst MODF_EAX+MODF_FLAGS        sbb   AH,AL
inst MODF_EAX+MODF_FLAGS        sbb   AH,BL
inst MODF_EAX+MODF_FLAGS        sbb   AH,BH
inst MODF_EAX+MODF_FLAGS        sbb   AH,CL
inst MODF_EAX+MODF_FLAGS        sbb   AH,CH
inst MODF_EAX+MODF_FLAGS        sbb   AH,DL
inst MODF_EAX+MODF_FLAGS        sbb   AH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sbb EBX,XXX
;
inst MODF_EBX+MODF_FLAGS        sbb   EBX,EAX
inst MODF_EBX+MODF_FLAGS        sbb   EBX,EDX
inst MODF_EBX+MODF_FLAGS        sbb   EBX,ECX
inst MODF_EBX+MODF_FLAGS        sbb   EBX,ESI
inst MODF_EBX+MODF_FLAGS        sbb   EBX,EDI
inst MODF_EBX+MODF_FLAGS        sbb   EBX,EBP
inst MODF_EBX+MODF_FLAGS        sbb   BL,AL
inst MODF_EBX+MODF_FLAGS        sbb   BL,AH
inst MODF_EBX+MODF_FLAGS        sbb   BL,BH
inst MODF_EBX+MODF_FLAGS        sbb   BL,CL
inst MODF_EBX+MODF_FLAGS        sbb   BL,CH
inst MODF_EBX+MODF_FLAGS        sbb   BL,DL
inst MODF_EBX+MODF_FLAGS        sbb   BL,DH
inst MODF_EBX+MODF_FLAGS        sbb   BH,AL
inst MODF_EBX+MODF_FLAGS        sbb   BH,AH
inst MODF_EBX+MODF_FLAGS        sbb   BH,BL
inst MODF_EBX+MODF_FLAGS        sbb   BH,CL
inst MODF_EBX+MODF_FLAGS        sbb   BH,CH
inst MODF_EBX+MODF_FLAGS        sbb   BH,DL
inst MODF_EBX+MODF_FLAGS        sbb   BH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sbb ECX,XXX
;
inst MODF_ECX+MODF_FLAGS        sbb   ECX,EAX
inst MODF_ECX+MODF_FLAGS        sbb   ECX,EBX
inst MODF_ECX+MODF_FLAGS        sbb   ECX,EDX
inst MODF_ECX+MODF_FLAGS        sbb   ECX,ESI
inst MODF_ECX+MODF_FLAGS        sbb   ECX,EDI
inst MODF_ECX+MODF_FLAGS        sbb   ECX,EBP
inst MODF_ECX+MODF_FLAGS        sbb   CL,AL
inst MODF_ECX+MODF_FLAGS        sbb   CL,AH
inst MODF_ECX+MODF_FLAGS        sbb   CL,BL
inst MODF_ECX+MODF_FLAGS        sbb   CL,BH
inst MODF_ECX+MODF_FLAGS        sbb   CL,CH
inst MODF_ECX+MODF_FLAGS        sbb   CL,DL
inst MODF_ECX+MODF_FLAGS        sbb   CL,DH
inst MODF_ECX+MODF_FLAGS        sbb   CH,AL
inst MODF_ECX+MODF_FLAGS        sbb   CH,AH
inst MODF_ECX+MODF_FLAGS        sbb   CH,BL
inst MODF_ECX+MODF_FLAGS        sbb   CH,BH
inst MODF_ECX+MODF_FLAGS        sbb   CH,CL
inst MODF_ECX+MODF_FLAGS        sbb   CH,DL
inst MODF_ECX+MODF_FLAGS        sbb   CH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sbb EDX,XXX
;
inst MODF_EDX+MODF_FLAGS        sbb   EDX,EAX
inst MODF_EDX+MODF_FLAGS        sbb   EDX,EBX
inst MODF_EDX+MODF_FLAGS        sbb   EDX,ECX
inst MODF_EDX+MODF_FLAGS        sbb   EDX,ESI
inst MODF_EDX+MODF_FLAGS        sbb   EDX,EDI
inst MODF_EDX+MODF_FLAGS        sbb   EDX,EBP
inst MODF_EDX+MODF_FLAGS        sbb   DL,AL
inst MODF_EDX+MODF_FLAGS        sbb   DL,AH
inst MODF_EDX+MODF_FLAGS        sbb   DL,BL
inst MODF_EDX+MODF_FLAGS        sbb   DL,BH
inst MODF_EDX+MODF_FLAGS        sbb   DL,CL
inst MODF_EDX+MODF_FLAGS        sbb   DL,CH
inst MODF_EDX+MODF_FLAGS        sbb   DL,DH
inst MODF_EDX+MODF_FLAGS        sbb   DH,AL
inst MODF_EDX+MODF_FLAGS        sbb   DH,AH
inst MODF_EDX+MODF_FLAGS        sbb   DH,BL
inst MODF_EDX+MODF_FLAGS        sbb   DH,BH
inst MODF_EDX+MODF_FLAGS        sbb   DH,CL
inst MODF_EDX+MODF_FLAGS        sbb   DH,CH
inst MODF_EDX+MODF_FLAGS        sbb   DH,DL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sbb ESI,XXX
;
inst MODF_ESI+MODF_FLAGS        sbb   ESI,EAX
inst MODF_ESI+MODF_FLAGS        sbb   ESI,EBX
inst MODF_ESI+MODF_FLAGS        sbb   ESI,ECX
inst MODF_ESI+MODF_FLAGS        sbb   ESI,EDX
inst MODF_ESI+MODF_FLAGS        sbb   ESI,EDI
inst MODF_ESI+MODF_FLAGS        sbb   ESI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sbb EDI,XXX
;
inst MODF_EDI+MODF_FLAGS        sbb   EDI,EAX
inst MODF_EDI+MODF_FLAGS        sbb   EDI,EBX
inst MODF_EDI+MODF_FLAGS        sbb   EDI,ECX
inst MODF_EDI+MODF_FLAGS        sbb   EDI,EDX
inst MODF_EDI+MODF_FLAGS        sbb   EDI,ESI
inst MODF_EDI+MODF_FLAGS        sbb   EDI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sbb EBP,XXX
;
inst MODF_EBP+MODF_FLAGS        sbb   EBP,EAX
inst MODF_EBP+MODF_FLAGS        sbb   EBP,EBX
inst MODF_EBP+MODF_FLAGS        sbb   EBP,ECX
inst MODF_EBP+MODF_FLAGS        sbb   EBP,EDX
inst MODF_EBP+MODF_FLAGS        sbb   EBP,ESI
inst MODF_EBP+MODF_FLAGS        sbb   EBP,EDI


;----------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; or EAX,XXX (don't or byte registers because of 'bad' code)
;
inst MODF_EAX+MODF_FLAGS        or   EAX,EBX
inst MODF_EAX+MODF_FLAGS        or   EAX,EDX
inst MODF_EAX+MODF_FLAGS        or   EAX,ECX
inst MODF_EAX+MODF_FLAGS        or   EAX,ESI
inst MODF_EAX+MODF_FLAGS        or   EAX,EDI
inst MODF_EAX+MODF_FLAGS        or   EAX,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; or EBX,XXX
;
inst MODF_EBX+MODF_FLAGS        or   EBX,EAX
inst MODF_EBX+MODF_FLAGS        or   EBX,EDX
inst MODF_EBX+MODF_FLAGS        or   EBX,ECX
inst MODF_EBX+MODF_FLAGS        or   EBX,ESI
inst MODF_EBX+MODF_FLAGS        or   EBX,EDI
inst MODF_EBX+MODF_FLAGS        or   EBX,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; or ECX,XXX
;
inst MODF_ECX+MODF_FLAGS        or   ECX,EAX
inst MODF_ECX+MODF_FLAGS        or   ECX,EBX
inst MODF_ECX+MODF_FLAGS        or   ECX,EDX
inst MODF_ECX+MODF_FLAGS        or   ECX,ESI
inst MODF_ECX+MODF_FLAGS        or   ECX,EDI
inst MODF_ECX+MODF_FLAGS        or   ECX,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; or EDX,XXX
;
inst MODF_EDX+MODF_FLAGS        or   EDX,EAX
inst MODF_EDX+MODF_FLAGS        or   EDX,EBX
inst MODF_EDX+MODF_FLAGS        or   EDX,ECX
inst MODF_EDX+MODF_FLAGS        or   EDX,ESI
inst MODF_EDX+MODF_FLAGS        or   EDX,EDI
inst MODF_EDX+MODF_FLAGS        or   EDX,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; or ESI,XXX
;
inst MODF_ESI+MODF_FLAGS        or   ESI,EAX
inst MODF_ESI+MODF_FLAGS        or   ESI,EBX
inst MODF_ESI+MODF_FLAGS        or   ESI,ECX
inst MODF_ESI+MODF_FLAGS        or   ESI,EDX
inst MODF_ESI+MODF_FLAGS        or   ESI,EDI
inst MODF_ESI+MODF_FLAGS        or   ESI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; or EDI,XXX
;
inst MODF_EDI+MODF_FLAGS        or   EDI,EAX
inst MODF_EDI+MODF_FLAGS        or   EDI,EBX
inst MODF_EDI+MODF_FLAGS        or   EDI,ECX
inst MODF_EDI+MODF_FLAGS        or   EDI,EDX
inst MODF_EDI+MODF_FLAGS        or   EDI,ESI
inst MODF_EDI+MODF_FLAGS        or   EDI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; or EBP,XXX
;
inst MODF_EBP+MODF_FLAGS        or   EBP,EAX
inst MODF_EBP+MODF_FLAGS        or   EBP,EBX
inst MODF_EBP+MODF_FLAGS        or   EBP,ECX
inst MODF_EBP+MODF_FLAGS        or   EBP,EDX
inst MODF_EBP+MODF_FLAGS        or   EBP,ESI
inst MODF_EBP+MODF_FLAGS        or   EBP,EDI


;----------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; and EAX,XXX
;
inst MODF_EAX+MODF_FLAGS        and   EAX,EBX
inst MODF_EAX+MODF_FLAGS        and   EAX,EDX
inst MODF_EAX+MODF_FLAGS        and   EAX,ECX
inst MODF_EAX+MODF_FLAGS        and   EAX,ESI
inst MODF_EAX+MODF_FLAGS        and   EAX,EDI
inst MODF_EAX+MODF_FLAGS        and   EAX,EBP
inst MODF_EAX+MODF_FLAGS        and   AL,AH
inst MODF_EAX+MODF_FLAGS        and   AL,BL
inst MODF_EAX+MODF_FLAGS        and   AL,BH
inst MODF_EAX+MODF_FLAGS        and   AL,CL
inst MODF_EAX+MODF_FLAGS        and   AL,CH
inst MODF_EAX+MODF_FLAGS        and   AL,DL
inst MODF_EAX+MODF_FLAGS        and   AL,DH
inst MODF_EAX+MODF_FLAGS        and   AH,AL
inst MODF_EAX+MODF_FLAGS        and   AH,BL
inst MODF_EAX+MODF_FLAGS        and   AH,BH
inst MODF_EAX+MODF_FLAGS        and   AH,CL
inst MODF_EAX+MODF_FLAGS        and   AH,CH
inst MODF_EAX+MODF_FLAGS        and   AH,DL
inst MODF_EAX+MODF_FLAGS        and   AH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; and EBX,XXX
;
inst MODF_EBX+MODF_FLAGS        and   EBX,EAX
inst MODF_EBX+MODF_FLAGS        and   EBX,EDX
inst MODF_EBX+MODF_FLAGS        and   EBX,ECX
inst MODF_EBX+MODF_FLAGS        and   EBX,ESI
inst MODF_EBX+MODF_FLAGS        and   EBX,EDI
inst MODF_EBX+MODF_FLAGS        and   EBX,EBP
inst MODF_EBX+MODF_FLAGS        and   BL,AL
inst MODF_EBX+MODF_FLAGS        and   BL,AH
inst MODF_EBX+MODF_FLAGS        and   BL,BH
inst MODF_EBX+MODF_FLAGS        and   BL,CL
inst MODF_EBX+MODF_FLAGS        and   BL,CH
inst MODF_EBX+MODF_FLAGS        and   BL,DL
inst MODF_EBX+MODF_FLAGS        and   BL,DH
inst MODF_EBX+MODF_FLAGS        and   BH,AL
inst MODF_EBX+MODF_FLAGS        and   BH,AH
inst MODF_EBX+MODF_FLAGS        and   BH,BL
inst MODF_EBX+MODF_FLAGS        and   BH,CL
inst MODF_EBX+MODF_FLAGS        and   BH,CH
inst MODF_EBX+MODF_FLAGS        and   BH,DL
inst MODF_EBX+MODF_FLAGS        and   BH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; and ECX,XXX
;
inst MODF_ECX+MODF_FLAGS        and   ECX,EAX
inst MODF_ECX+MODF_FLAGS        and   ECX,EBX
inst MODF_ECX+MODF_FLAGS        and   ECX,EDX
inst MODF_ECX+MODF_FLAGS        and   ECX,ESI
inst MODF_ECX+MODF_FLAGS        and   ECX,EDI
inst MODF_ECX+MODF_FLAGS        and   ECX,EBP
inst MODF_ECX+MODF_FLAGS        and   CL,AL
inst MODF_ECX+MODF_FLAGS        and   CL,AH
inst MODF_ECX+MODF_FLAGS        and   CL,BL
inst MODF_ECX+MODF_FLAGS        and   CL,BH
inst MODF_ECX+MODF_FLAGS        and   CL,CH
inst MODF_ECX+MODF_FLAGS        and   CL,DL
inst MODF_ECX+MODF_FLAGS        and   CL,DH
inst MODF_ECX+MODF_FLAGS        and   CH,AL
inst MODF_ECX+MODF_FLAGS        and   CH,AH
inst MODF_ECX+MODF_FLAGS        and   CH,BL
inst MODF_ECX+MODF_FLAGS        and   CH,BH
inst MODF_ECX+MODF_FLAGS        and   CH,CL
inst MODF_ECX+MODF_FLAGS        and   CH,DL
inst MODF_ECX+MODF_FLAGS        and   CH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; and EDX,XXX
;
inst MODF_EDX+MODF_FLAGS        and   EDX,EAX
inst MODF_EDX+MODF_FLAGS        and   EDX,EBX
inst MODF_EDX+MODF_FLAGS        and   EDX,ECX
inst MODF_EDX+MODF_FLAGS        and   EDX,ESI
inst MODF_EDX+MODF_FLAGS        and   EDX,EDI
inst MODF_EDX+MODF_FLAGS        and   EDX,EBP
inst MODF_EDX+MODF_FLAGS        and   DL,AL
inst MODF_EDX+MODF_FLAGS        and   DL,AH
inst MODF_EDX+MODF_FLAGS        and   DL,BL
inst MODF_EDX+MODF_FLAGS        and   DL,BH
inst MODF_EDX+MODF_FLAGS        and   DL,CL
inst MODF_EDX+MODF_FLAGS        and   DL,CH
inst MODF_EDX+MODF_FLAGS        and   DL,DH
inst MODF_EDX+MODF_FLAGS        and   DH,AL
inst MODF_EDX+MODF_FLAGS        and   DH,AH
inst MODF_EDX+MODF_FLAGS        and   DH,BL
inst MODF_EDX+MODF_FLAGS        and   DH,BH
inst MODF_EDX+MODF_FLAGS        and   DH,CL
inst MODF_EDX+MODF_FLAGS        and   DH,CH
inst MODF_EDX+MODF_FLAGS        and   DH,DL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; and ESI,XXX
;
inst MODF_ESI+MODF_FLAGS        and   ESI,EAX
inst MODF_ESI+MODF_FLAGS        and   ESI,EBX
inst MODF_ESI+MODF_FLAGS        and   ESI,ECX
inst MODF_ESI+MODF_FLAGS        and   ESI,EDX
inst MODF_ESI+MODF_FLAGS        and   ESI,EDI
inst MODF_ESI+MODF_FLAGS        and   ESI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; and EDI,XXX
;
inst MODF_EDI+MODF_FLAGS        and   EDI,EAX
inst MODF_EDI+MODF_FLAGS        and   EDI,EBX
inst MODF_EDI+MODF_FLAGS        and   EDI,ECX
inst MODF_EDI+MODF_FLAGS        and   EDI,EDX
inst MODF_EDI+MODF_FLAGS        and   EDI,ESI
inst MODF_EDI+MODF_FLAGS        and   EDI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; and EBP,XXX
;
inst MODF_EBP+MODF_FLAGS        and   EBP,EAX
inst MODF_EBP+MODF_FLAGS        and   EBP,EBX
inst MODF_EBP+MODF_FLAGS        and   EBP,ECX
inst MODF_EBP+MODF_FLAGS        and   EBP,EDX
inst MODF_EBP+MODF_FLAGS        and   EBP,ESI
inst MODF_EBP+MODF_FLAGS        and   EBP,EDI


;----------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; xor EAX,XXX
;
inst MODF_EAX+MODF_FLAGS        xor   EAX,EBX
inst MODF_EAX+MODF_FLAGS        xor   EAX,EDX
inst MODF_EAX+MODF_FLAGS        xor   EAX,ECX
inst MODF_EAX+MODF_FLAGS        xor   EAX,ESI
inst MODF_EAX+MODF_FLAGS        xor   EAX,EDI
inst MODF_EAX+MODF_FLAGS        xor   EAX,EBP
inst MODF_EAX+MODF_FLAGS        xor   AL,AH
inst MODF_EAX+MODF_FLAGS        xor   AL,BL
inst MODF_EAX+MODF_FLAGS        xor   AL,BH
inst MODF_EAX+MODF_FLAGS        xor   AL,CL
inst MODF_EAX+MODF_FLAGS        xor   AL,CH
inst MODF_EAX+MODF_FLAGS        xor   AL,DL
inst MODF_EAX+MODF_FLAGS        xor   AL,DH
inst MODF_EAX+MODF_FLAGS        xor   AH,AL
inst MODF_EAX+MODF_FLAGS        xor   AH,BL
inst MODF_EAX+MODF_FLAGS        xor   AH,BH
inst MODF_EAX+MODF_FLAGS        xor   AH,CL
inst MODF_EAX+MODF_FLAGS        xor   AH,CH
inst MODF_EAX+MODF_FLAGS        xor   AH,DL
inst MODF_EAX+MODF_FLAGS        xor   AH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; xor EBX,XXX
;
inst MODF_EBX+MODF_FLAGS        xor   EBX,EAX
inst MODF_EBX+MODF_FLAGS        xor   EBX,EDX
inst MODF_EBX+MODF_FLAGS        xor   EBX,ECX
inst MODF_EBX+MODF_FLAGS        xor   EBX,ESI
inst MODF_EBX+MODF_FLAGS        xor   EBX,EDI
inst MODF_EBX+MODF_FLAGS        xor   EBX,EBP
inst MODF_EBX+MODF_FLAGS        xor   BL,AL
inst MODF_EBX+MODF_FLAGS        xor   BL,AH
inst MODF_EBX+MODF_FLAGS        xor   BL,BH
inst MODF_EBX+MODF_FLAGS        xor   BL,CL
inst MODF_EBX+MODF_FLAGS        xor   BL,CH
inst MODF_EBX+MODF_FLAGS        xor   BL,DL
inst MODF_EBX+MODF_FLAGS        xor   BL,DH
inst MODF_EBX+MODF_FLAGS        xor   BH,AL
inst MODF_EBX+MODF_FLAGS        xor   BH,AH
inst MODF_EBX+MODF_FLAGS        xor   BH,BL
inst MODF_EBX+MODF_FLAGS        xor   BH,CL
inst MODF_EBX+MODF_FLAGS        xor   BH,CH
inst MODF_EBX+MODF_FLAGS        xor   BH,DL
inst MODF_EBX+MODF_FLAGS        xor   BH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; xor ECX,XXX
;
inst MODF_ECX+MODF_FLAGS        xor   ECX,EAX
inst MODF_ECX+MODF_FLAGS        xor   ECX,EBX
inst MODF_ECX+MODF_FLAGS        xor   ECX,EDX
inst MODF_ECX+MODF_FLAGS        xor   ECX,ESI
inst MODF_ECX+MODF_FLAGS        xor   ECX,EDI
inst MODF_ECX+MODF_FLAGS        xor   ECX,EBP
inst MODF_ECX+MODF_FLAGS        xor   CL,AL
inst MODF_ECX+MODF_FLAGS        xor   CL,AH
inst MODF_ECX+MODF_FLAGS        xor   CL,BL
inst MODF_ECX+MODF_FLAGS        xor   CL,BH
inst MODF_ECX+MODF_FLAGS        xor   CL,CH
inst MODF_ECX+MODF_FLAGS        xor   CL,DL
inst MODF_ECX+MODF_FLAGS        xor   CL,DH
inst MODF_ECX+MODF_FLAGS        xor   CH,AL
inst MODF_ECX+MODF_FLAGS        xor   CH,AH
inst MODF_ECX+MODF_FLAGS        xor   CH,BL
inst MODF_ECX+MODF_FLAGS        xor   CH,BH
inst MODF_ECX+MODF_FLAGS        xor   CH,CL
inst MODF_ECX+MODF_FLAGS        xor   CH,DL
inst MODF_ECX+MODF_FLAGS        xor   CH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; xor EDX,XXX
;
inst MODF_EDX+MODF_FLAGS        xor   EDX,EAX
inst MODF_EDX+MODF_FLAGS        xor   EDX,EBX
inst MODF_EDX+MODF_FLAGS        xor   EDX,ECX
inst MODF_EDX+MODF_FLAGS        xor   EDX,ESI
inst MODF_EDX+MODF_FLAGS        xor   EDX,EDI
inst MODF_EDX+MODF_FLAGS        xor   EDX,EBP
inst MODF_EDX+MODF_FLAGS        xor   DL,AL
inst MODF_EDX+MODF_FLAGS        xor   DL,AH
inst MODF_EDX+MODF_FLAGS        xor   DL,BL
inst MODF_EDX+MODF_FLAGS        xor   DL,BH
inst MODF_EDX+MODF_FLAGS        xor   DL,CL
inst MODF_EDX+MODF_FLAGS        xor   DL,CH
inst MODF_EDX+MODF_FLAGS        xor   DL,DH
inst MODF_EDX+MODF_FLAGS        xor   DH,AL
inst MODF_EDX+MODF_FLAGS        xor   DH,AH
inst MODF_EDX+MODF_FLAGS        xor   DH,BL
inst MODF_EDX+MODF_FLAGS        xor   DH,BH
inst MODF_EDX+MODF_FLAGS        xor   DH,CL
inst MODF_EDX+MODF_FLAGS        xor   DH,CH
inst MODF_EDX+MODF_FLAGS        xor   DH,DL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; xor ESI,XXX
;
inst MODF_ESI+MODF_FLAGS        xor   ESI,EAX
inst MODF_ESI+MODF_FLAGS        xor   ESI,EBX
inst MODF_ESI+MODF_FLAGS        xor   ESI,ECX
inst MODF_ESI+MODF_FLAGS        xor   ESI,EDX
inst MODF_ESI+MODF_FLAGS        xor   ESI,EDI
inst MODF_ESI+MODF_FLAGS        xor   ESI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; xor EDI,XXX
;
inst MODF_EDI+MODF_FLAGS        xor   EDI,EAX
inst MODF_EDI+MODF_FLAGS        xor   EDI,EBX
inst MODF_EDI+MODF_FLAGS        xor   EDI,ECX
inst MODF_EDI+MODF_FLAGS        xor   EDI,EDX
inst MODF_EDI+MODF_FLAGS        xor   EDI,ESI
inst MODF_EDI+MODF_FLAGS        xor   EDI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; xor EBP,XXX
;
inst MODF_EBP+MODF_FLAGS        xor   EBP,EAX
inst MODF_EBP+MODF_FLAGS        xor   EBP,EBX
inst MODF_EBP+MODF_FLAGS        xor   EBP,ECX
inst MODF_EBP+MODF_FLAGS        xor   EBP,EDX
inst MODF_EBP+MODF_FLAGS        xor   EBP,ESI
inst MODF_EBP+MODF_FLAGS        xor   EBP,EDI


;----------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; test EAX,XXX
;
inst MODF_EAX+MODF_FLAGS        test   EAX,EBX
inst MODF_EAX+MODF_FLAGS        test   EAX,EDX
inst MODF_EAX+MODF_FLAGS        test   EAX,ECX
inst MODF_EAX+MODF_FLAGS        test   EAX,ESI
inst MODF_EAX+MODF_FLAGS        test   EAX,EDI
inst MODF_EAX+MODF_FLAGS        test   EAX,EBP
inst MODF_EAX+MODF_FLAGS        test   AL,AH
inst MODF_EAX+MODF_FLAGS        test   AL,BL
inst MODF_EAX+MODF_FLAGS        test   AL,BH
inst MODF_EAX+MODF_FLAGS        test   AL,CL
inst MODF_EAX+MODF_FLAGS        test   AL,CH
inst MODF_EAX+MODF_FLAGS        test   AL,DL
inst MODF_EAX+MODF_FLAGS        test   AL,DH
inst MODF_EAX+MODF_FLAGS        test   AH,AL
inst MODF_EAX+MODF_FLAGS        test   AH,BL
inst MODF_EAX+MODF_FLAGS        test   AH,BH
inst MODF_EAX+MODF_FLAGS        test   AH,CL
inst MODF_EAX+MODF_FLAGS        test   AH,CH
inst MODF_EAX+MODF_FLAGS        test   AH,DL
inst MODF_EAX+MODF_FLAGS        test   AH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; test EBX,XXX
;
inst MODF_EBX+MODF_FLAGS        test   EBX,EAX
inst MODF_EBX+MODF_FLAGS        test   EBX,EDX
inst MODF_EBX+MODF_FLAGS        test   EBX,ECX
inst MODF_EBX+MODF_FLAGS        test   EBX,ESI
inst MODF_EBX+MODF_FLAGS        test   EBX,EDI
inst MODF_EBX+MODF_FLAGS        test   EBX,EBP
inst MODF_EBX+MODF_FLAGS        test   BL,AL
inst MODF_EBX+MODF_FLAGS        test   BL,AH
inst MODF_EBX+MODF_FLAGS        test   BL,BH
inst MODF_EBX+MODF_FLAGS        test   BL,CL
inst MODF_EBX+MODF_FLAGS        test   BL,CH
inst MODF_EBX+MODF_FLAGS        test   BL,DL
inst MODF_EBX+MODF_FLAGS        test   BL,DH
inst MODF_EBX+MODF_FLAGS        test   BH,AL
inst MODF_EBX+MODF_FLAGS        test   BH,AH
inst MODF_EBX+MODF_FLAGS        test   BH,BL
inst MODF_EBX+MODF_FLAGS        test   BH,CL
inst MODF_EBX+MODF_FLAGS        test   BH,CH
inst MODF_EBX+MODF_FLAGS        test   BH,DL
inst MODF_EBX+MODF_FLAGS        test   BH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; test ECX,XXX
;
inst MODF_ECX+MODF_FLAGS        test   ECX,EAX
inst MODF_ECX+MODF_FLAGS        test   ECX,EBX
inst MODF_ECX+MODF_FLAGS        test   ECX,EDX
inst MODF_ECX+MODF_FLAGS        test   ECX,ESI
inst MODF_ECX+MODF_FLAGS        test   ECX,EDI
inst MODF_ECX+MODF_FLAGS        test   ECX,EBP
inst MODF_ECX+MODF_FLAGS        test   CL,AL
inst MODF_ECX+MODF_FLAGS        test   CL,AH
inst MODF_ECX+MODF_FLAGS        test   CL,BL
inst MODF_ECX+MODF_FLAGS        test   CL,BH
inst MODF_ECX+MODF_FLAGS        test   CL,CH
inst MODF_ECX+MODF_FLAGS        test   CL,DL
inst MODF_ECX+MODF_FLAGS        test   CL,DH
inst MODF_ECX+MODF_FLAGS        test   CH,AL
inst MODF_ECX+MODF_FLAGS        test   CH,AH
inst MODF_ECX+MODF_FLAGS        test   CH,BL
inst MODF_ECX+MODF_FLAGS        test   CH,BH
inst MODF_ECX+MODF_FLAGS        test   CH,CL
inst MODF_ECX+MODF_FLAGS        test   CH,DL
inst MODF_ECX+MODF_FLAGS        test   CH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; test EDX,XXX
;
inst MODF_EDX+MODF_FLAGS        test   EDX,EAX
inst MODF_EDX+MODF_FLAGS        test   EDX,EBX
inst MODF_EDX+MODF_FLAGS        test   EDX,ECX
inst MODF_EDX+MODF_FLAGS        test   EDX,ESI
inst MODF_EDX+MODF_FLAGS        test   EDX,EDI
inst MODF_EDX+MODF_FLAGS        test   EDX,EBP
inst MODF_EDX+MODF_FLAGS        test   DL,AL
inst MODF_EDX+MODF_FLAGS        test   DL,AH
inst MODF_EDX+MODF_FLAGS        test   DL,BL
inst MODF_EDX+MODF_FLAGS        test   DL,BH
inst MODF_EDX+MODF_FLAGS        test   DL,CL
inst MODF_EDX+MODF_FLAGS        test   DL,CH
inst MODF_EDX+MODF_FLAGS        test   DL,DH
inst MODF_EDX+MODF_FLAGS        test   DH,AL
inst MODF_EDX+MODF_FLAGS        test   DH,AH
inst MODF_EDX+MODF_FLAGS        test   DH,BL
inst MODF_EDX+MODF_FLAGS        test   DH,BH
inst MODF_EDX+MODF_FLAGS        test   DH,CL
inst MODF_EDX+MODF_FLAGS        test   DH,CH
inst MODF_EDX+MODF_FLAGS        test   DH,DL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; test ESI,XXX
;
inst MODF_ESI+MODF_FLAGS        test   ESI,EAX
inst MODF_ESI+MODF_FLAGS        test   ESI,EBX
inst MODF_ESI+MODF_FLAGS        test   ESI,ECX
inst MODF_ESI+MODF_FLAGS        test   ESI,EDX
inst MODF_ESI+MODF_FLAGS        test   ESI,EDI
inst MODF_ESI+MODF_FLAGS        test   ESI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; test EDI,XXX
;
inst MODF_EDI+MODF_FLAGS        test   EDI,EAX
inst MODF_EDI+MODF_FLAGS        test   EDI,EBX
inst MODF_EDI+MODF_FLAGS        test   EDI,ECX
inst MODF_EDI+MODF_FLAGS        test   EDI,EDX
inst MODF_EDI+MODF_FLAGS        test   EDI,ESI
inst MODF_EDI+MODF_FLAGS        test   EDI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; test EBP,XXX
;
inst MODF_EBP+MODF_FLAGS        test   EBP,EAX
inst MODF_EBP+MODF_FLAGS        test   EBP,EBX
inst MODF_EBP+MODF_FLAGS        test   EBP,ECX
inst MODF_EBP+MODF_FLAGS        test   EBP,EDX
inst MODF_EBP+MODF_FLAGS        test   EBP,ESI
inst MODF_EBP+MODF_FLAGS        test   EBP,EDI


;----------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; cmp EAX,XXX
;
inst MODF_EAX+MODF_FLAGS        cmp   EAX,EBX
inst MODF_EAX+MODF_FLAGS        cmp   EAX,EDX
inst MODF_EAX+MODF_FLAGS        cmp   EAX,ECX
inst MODF_EAX+MODF_FLAGS        cmp   EAX,ESI
inst MODF_EAX+MODF_FLAGS        cmp   EAX,EDI
inst MODF_EAX+MODF_FLAGS        cmp   EAX,EBP
inst MODF_EAX+MODF_FLAGS        cmp   AL,AH
inst MODF_EAX+MODF_FLAGS        cmp   AL,BL
inst MODF_EAX+MODF_FLAGS        cmp   AL,BH
inst MODF_EAX+MODF_FLAGS        cmp   AL,CL
inst MODF_EAX+MODF_FLAGS        cmp   AL,CH
inst MODF_EAX+MODF_FLAGS        cmp   AL,DL
inst MODF_EAX+MODF_FLAGS        cmp   AL,DH
inst MODF_EAX+MODF_FLAGS        cmp   AH,AL
inst MODF_EAX+MODF_FLAGS        cmp   AH,BL
inst MODF_EAX+MODF_FLAGS        cmp   AH,BH
inst MODF_EAX+MODF_FLAGS        cmp   AH,CL
inst MODF_EAX+MODF_FLAGS        cmp   AH,CH
inst MODF_EAX+MODF_FLAGS        cmp   AH,DL
inst MODF_EAX+MODF_FLAGS        cmp   AH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; cmp EBX,XXX
;
inst MODF_EBX+MODF_FLAGS        cmp   EBX,EAX
inst MODF_EBX+MODF_FLAGS        cmp   EBX,EDX
inst MODF_EBX+MODF_FLAGS        cmp   EBX,ECX
inst MODF_EBX+MODF_FLAGS        cmp   EBX,ESI
inst MODF_EBX+MODF_FLAGS        cmp   EBX,EDI
inst MODF_EBX+MODF_FLAGS        cmp   EBX,EBP
inst MODF_EBX+MODF_FLAGS        cmp   BL,AL
inst MODF_EBX+MODF_FLAGS        cmp   BL,AH
inst MODF_EBX+MODF_FLAGS        cmp   BL,BH
inst MODF_EBX+MODF_FLAGS        cmp   BL,CL
inst MODF_EBX+MODF_FLAGS        cmp   BL,CH
inst MODF_EBX+MODF_FLAGS        cmp   BL,DL
inst MODF_EBX+MODF_FLAGS        cmp   BL,DH
inst MODF_EBX+MODF_FLAGS        cmp   BH,AL
inst MODF_EBX+MODF_FLAGS        cmp   BH,AH
inst MODF_EBX+MODF_FLAGS        cmp   BH,BL
inst MODF_EBX+MODF_FLAGS        cmp   BH,CL
inst MODF_EBX+MODF_FLAGS        cmp   BH,CH
inst MODF_EBX+MODF_FLAGS        cmp   BH,DL
inst MODF_EBX+MODF_FLAGS        cmp   BH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; cmp ECX,XXX
;
inst MODF_ECX+MODF_FLAGS        cmp   ECX,EAX
inst MODF_ECX+MODF_FLAGS        cmp   ECX,EBX
inst MODF_ECX+MODF_FLAGS        cmp   ECX,EDX
inst MODF_ECX+MODF_FLAGS        cmp   ECX,ESI
inst MODF_ECX+MODF_FLAGS        cmp   ECX,EDI
inst MODF_ECX+MODF_FLAGS        cmp   ECX,EBP
inst MODF_ECX+MODF_FLAGS        cmp   CL,AL
inst MODF_ECX+MODF_FLAGS        cmp   CL,AH
inst MODF_ECX+MODF_FLAGS        cmp   CL,BL
inst MODF_ECX+MODF_FLAGS        cmp   CL,BH
inst MODF_ECX+MODF_FLAGS        cmp   CL,CH
inst MODF_ECX+MODF_FLAGS        cmp   CL,DL
inst MODF_ECX+MODF_FLAGS        cmp   CL,DH
inst MODF_ECX+MODF_FLAGS        cmp   CH,AL
inst MODF_ECX+MODF_FLAGS        cmp   CH,AH
inst MODF_ECX+MODF_FLAGS        cmp   CH,BL
inst MODF_ECX+MODF_FLAGS        cmp   CH,BH
inst MODF_ECX+MODF_FLAGS        cmp   CH,CL
inst MODF_ECX+MODF_FLAGS        cmp   CH,DL
inst MODF_ECX+MODF_FLAGS        cmp   CH,DH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; cmp EDX,XXX
;
inst MODF_EDX+MODF_FLAGS        cmp   EDX,EAX
inst MODF_EDX+MODF_FLAGS        cmp   EDX,EBX
inst MODF_EDX+MODF_FLAGS        cmp   EDX,ECX
inst MODF_EDX+MODF_FLAGS        cmp   EDX,ESI
inst MODF_EDX+MODF_FLAGS        cmp   EDX,EDI
inst MODF_EDX+MODF_FLAGS        cmp   EDX,EBP
inst MODF_EDX+MODF_FLAGS        cmp   DL,AL
inst MODF_EDX+MODF_FLAGS        cmp   DL,AH
inst MODF_EDX+MODF_FLAGS        cmp   DL,BL
inst MODF_EDX+MODF_FLAGS        cmp   DL,BH
inst MODF_EDX+MODF_FLAGS        cmp   DL,CL
inst MODF_EDX+MODF_FLAGS        cmp   DL,CH
inst MODF_EDX+MODF_FLAGS        cmp   DL,DH
inst MODF_EDX+MODF_FLAGS        cmp   DH,AL
inst MODF_EDX+MODF_FLAGS        cmp   DH,AH
inst MODF_EDX+MODF_FLAGS        cmp   DH,BL
inst MODF_EDX+MODF_FLAGS        cmp   DH,BH
inst MODF_EDX+MODF_FLAGS        cmp   DH,CL
inst MODF_EDX+MODF_FLAGS        cmp   DH,CH
inst MODF_EDX+MODF_FLAGS        cmp   DH,DL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; cmp ESI,XXX
;
inst MODF_ESI+MODF_FLAGS        cmp   ESI,EAX
inst MODF_ESI+MODF_FLAGS        cmp   ESI,EBX
inst MODF_ESI+MODF_FLAGS        cmp   ESI,ECX
inst MODF_ESI+MODF_FLAGS        cmp   ESI,EDX
inst MODF_ESI+MODF_FLAGS        cmp   ESI,EDI
inst MODF_ESI+MODF_FLAGS        cmp   ESI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; cmp EDI,XXX
;
inst MODF_EDI+MODF_FLAGS        cmp   EDI,EAX
inst MODF_EDI+MODF_FLAGS        cmp   EDI,EBX
inst MODF_EDI+MODF_FLAGS        cmp   EDI,ECX
inst MODF_EDI+MODF_FLAGS        cmp   EDI,EDX
inst MODF_EDI+MODF_FLAGS        cmp   EDI,ESI
inst MODF_EDI+MODF_FLAGS        cmp   EDI,EBP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; cmp EBP,XXX
;
inst MODF_EBP+MODF_FLAGS        cmp   EBP,EAX
inst MODF_EBP+MODF_FLAGS        cmp   EBP,EBX
inst MODF_EBP+MODF_FLAGS        cmp   EBP,ECX
inst MODF_EBP+MODF_FLAGS        cmp   EBP,EDX
inst MODF_EBP+MODF_FLAGS        cmp   EBP,ESI
inst MODF_EBP+MODF_FLAGS        cmp   EBP,EDI


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; mul
;

inst MODF_EAX+MODF_EDX+MODF_FLAGS       imul EAX
inst MODF_EAX+MODF_EDX+MODF_FLAGS       imul EBX
inst MODF_EAX+MODF_EDX+MODF_FLAGS       imul ECX
inst MODF_EAX+MODF_EDX+MODF_FLAGS       imul EDX
inst MODF_EAX+MODF_EDX+MODF_FLAGS       imul ESI
inst MODF_EAX+MODF_EDX+MODF_FLAGS       imul EDI
inst MODF_EAX+MODF_EDX+MODF_FLAGS       imul EBP

inst MODF_EAX+MODF_EDX+MODF_FLAGS       mul EAX
inst MODF_EAX+MODF_EDX+MODF_FLAGS       mul EBX
inst MODF_EAX+MODF_EDX+MODF_FLAGS       mul ECX
inst MODF_EAX+MODF_EDX+MODF_FLAGS       mul EDX
inst MODF_EAX+MODF_EDX+MODF_FLAGS       mul ESI
inst MODF_EAX+MODF_EDX+MODF_FLAGS       mul EDI
inst MODF_EAX+MODF_EDX+MODF_FLAGS       mul EBP

instr2 40h MODF_EAX+MODF_FLAGS  DB 069h 0C0h         ;  imul EAX,EAX,12345678h
instr2 40h MODF_EAX+MODF_FLAGS  DB 069h 0C3h         ;  imul EAX,EBX,12345678h
instr2 40h MODF_EAX+MODF_FLAGS  DB 069h 0C1h         ;  imul EAX,ECX,12345678h
instr2 40h MODF_EAX+MODF_FLAGS  DB 069h 0C2h         ;  imul EAX,EDX,12345678h
instr2 40h MODF_EAX+MODF_FLAGS  DB 069h 0C6h         ;  imul EAX,ESI,12345678h
instr2 40h MODF_EAX+MODF_FLAGS  DB 069h 0C7h         ;  imul EAX,EDI,12345678h
instr2 40h MODF_EAX+MODF_FLAGS  DB 069h 0C5h         ;  imul EAX,EBP,12345678h

instr2 40h MODF_EBX+MODF_FLAGS  DB 069h 0D8h         ;  imul EBX,EAX,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 069h 0DBh         ;  imul EBX,EBX,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 069h 0D9h         ;  imul EBX,ECX,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 069h 0DAh         ;  imul EBX,EDX,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 069h 0DEh         ;  imul EBX,ESI,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 069h 0DFh         ;  imul EBX,EDI,12345678h
instr2 40h MODF_EBX+MODF_FLAGS  DB 069h 0DDh         ;  imul EBX,EBP,12345678h

instr2 40h MODF_ECX+MODF_FLAGS  DB 069h 0C8h         ;  imul ECX,EAX,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 069h 0CBh         ;  imul ECX,EBX,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 069h 0C9h         ;  imul ECX,ECX,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 069h 0CAh         ;  imul ECX,EDX,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 069h 0CEh         ;  imul ECX,ESI,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 069h 0CFh         ;  imul ECX,EDI,12345678h
instr2 40h MODF_ECX+MODF_FLAGS  DB 069h 0CDh         ;  imul ECX,EBP,12345678h

instr2 40h MODF_EDX+MODF_FLAGS  DB 069h 0D0h         ;  imul EDX,EAX,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 069h 0D3h         ;  imul EDX,EBX,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 069h 0D1h         ;  imul EDX,ECX,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 069h 0D2h         ;  imul EDX,EDX,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 069h 0D6h         ;  imul EDX,ESI,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 069h 0D7h         ;  imul EDX,EDI,12345678h
instr2 40h MODF_EDX+MODF_FLAGS  DB 069h 0D5h         ;  imul EDX,EBP,12345678h

instr2 40h MODF_ESI+MODF_FLAGS  DB 069h 0F0h         ;  imul ESI,EAX,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 069h 0F3h         ;  imul ESI,EBX,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 069h 0F1h         ;  imul ESI,ECX,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 069h 0F2h         ;  imul ESI,EDX,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 069h 0F6h         ;  imul ESI,ESI,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 069h 0F7h         ;  imul ESI,EDI,12345678h
instr2 40h MODF_ESI+MODF_FLAGS  DB 069h 0F5h         ;  imul ESI,EBP,12345678h

instr2 40h MODF_EDI+MODF_FLAGS  DB 069h 0F8h         ;  imul EDI,EAX,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 069h 0FBh         ;  imul EDI,EBX,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 069h 0F9h         ;  imul EDI,ECX,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 069h 0FAh         ;  imul EDI,EDX,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 069h 0FEh         ;  imul EDI,ESI,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 069h 0FFh         ;  imul EDI,EDI,12345678h
instr2 40h MODF_EDI+MODF_FLAGS  DB 069h 0FDh         ;  imul EDI,EBP,12345678h


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; lea
;

inst MODF_EAX     lea   EAX,[EBX]
inst MODF_EBX     lea   EBX,[EBX]
inst MODF_ECX     lea   ECX,[EBX]
inst MODF_EDX     lea   EDX,[EBX]
inst MODF_ESI     lea   ESI,[EBX]
inst MODF_EDI     lea   EDI,[EBX]
inst MODF_EBP     lea   EBP,[EBX]

inst MODF_EAX     lea   EAX,[EBX+ESI]
inst MODF_EBX     lea   EBX,[EBX+ESI]
inst MODF_ECX     lea   ECX,[EBX+ESI]
inst MODF_EDX     lea   EDX,[EBX+ESI]
inst MODF_ESI     lea   ESI,[EBX+ESI]
inst MODF_EDI     lea   EDI,[EBX+ESI]
inst MODF_EBP     lea   EBP,[EBX+ESI]

inst MODF_EAX     lea   EAX,[EBX+EDI]
inst MODF_EBX     lea   EBX,[EBX+EDI]
inst MODF_ECX     lea   ECX,[EBX+EDI]
inst MODF_EDX     lea   EDX,[EBX+EDI]
inst MODF_ESI     lea   ESI,[EBX+EDI]
inst MODF_EDI     lea   EDI,[EBX+EDI]
inst MODF_EBP     lea   EBP,[EBX+EDI]

instr2 40h MODF_EAX    DB  08Dh 084h 033h     ; lea   EAX,[EBX+ESI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 033h     ; lea   EBX,[EBX+ESI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 033h     ; lea   ECX,[EBX+ESI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 033h     ; lea   EDX,[EBX+ESI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 033h     ; lea   ESI,[EBX+ESI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 033h     ; lea   EDI,[EBX+ESI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 033h     ; lea   EBP,[EBX+ESI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 03Bh     ; lea   EAX,[EBX+EDI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 03Bh     ; lea   EBX,[EBX+EDI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 03Bh     ; lea   ECX,[EBX+EDI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 03Bh     ; lea   EDX,[EBX+EDI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 03Bh     ; lea   ESI,[EBX+EDI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 03Bh     ; lea   EDI,[EBX+EDI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 03Bh     ; lea   EBP,[EBX+EDI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 030h     ; lea   EAX,[EAX+ESI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 030h     ; lea   EBX,[EAX+ESI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 030h     ; lea   ECX,[EAX+ESI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 030h     ; lea   EDX,[EAX+ESI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 030h     ; lea   ESI,[EAX+ESI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 030h     ; lea   EDI,[EAX+ESI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 030h     ; lea   EBP,[EAX+ESI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 038h     ; lea   EAX,[EAX+EDI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 038h     ; lea   EBX,[EAX+EDI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 038h     ; lea   ECX,[EAX+EDI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 038h     ; lea   EDX,[EAX+EDI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 038h     ; lea   ESI,[EAX+EDI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 038h     ; lea   EDI,[EAX+EDI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 038h     ; lea   EBP,[EAX+EDI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 031h     ; lea   EAX,[ECX+ESI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 031h     ; lea   EBX,[ECX+ESI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 031h     ; lea   ECX,[ECX+ESI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 031h     ; lea   EDX,[ECX+ESI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 031h     ; lea   ESI,[ECX+ESI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 031h     ; lea   EDI,[ECX+ESI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 031h     ; lea   EBP,[ECX+ESI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 039h     ; lea   EAX,[ECX+EDI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 039h     ; lea   EBX,[ECX+EDI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 039h     ; lea   ECX,[ECX+EDI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 039h     ; lea   EDX,[ECX+EDI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 039h     ; lea   ESI,[ECX+EDI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 039h     ; lea   EDI,[ECX+EDI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 039h     ; lea   EBP,[ECX+EDI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 032h     ; lea   EAX,[EDX+ESI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 032h     ; lea   EBX,[EDX+ESI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 032h     ; lea   ECX,[EDX+ESI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 032h     ; lea   EDX,[EDX+ESI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 032h     ; lea   ESI,[EDX+ESI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 032h     ; lea   EDI,[EDX+ESI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 032h     ; lea   EBP,[EDX+ESI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 03Ah     ; lea   EAX,[EDX+EDI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 03Ah     ; lea   EBX,[EDX+EDI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 03Ah     ; lea   ECX,[EDX+EDI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 03Ah     ; lea   EDX,[EDX+EDI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 03Ah     ; lea   ESI,[EDX+EDI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 03Ah     ; lea   EDI,[EDX+EDI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 03Ah     ; lea   EBP,[EDX+EDI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 030h     ; lea   EAX,[EAX+ESI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 030h     ; lea   EBX,[EAX+ESI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 030h     ; lea   ECX,[EAX+ESI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 030h     ; lea   EDX,[EAX+ESI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 030h     ; lea   ESI,[EAX+ESI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 030h     ; lea   EDI,[EAX+ESI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 030h     ; lea   EBP,[EAX+ESI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 038h     ; lea   EAX,[EAX+EDI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 038h     ; lea   EBX,[EAX+EDI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 038h     ; lea   ECX,[EAX+EDI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 038h     ; lea   EDX,[EAX+EDI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 038h     ; lea   ESI,[EAX+EDI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 038h     ; lea   EDI,[EAX+EDI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 038h     ; lea   EBP,[EAX+EDI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 030h     ; lea   EAX,[EAX+ESI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 030h     ; lea   EBX,[EAX+ESI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 030h     ; lea   ECX,[EAX+ESI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 030h     ; lea   EDX,[EAX+ESI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 030h     ; lea   ESI,[EAX+ESI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 030h     ; lea   EDI,[EAX+ESI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 030h     ; lea   EBP,[EAX+ESI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 038h     ; lea   EAX,[EAX+EDI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 038h     ; lea   EBX,[EAX+EDI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 038h     ; lea   ECX,[EAX+EDI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 038h     ; lea   EDX,[EAX+EDI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 038h     ; lea   ESI,[EAX+EDI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 038h     ; lea   EDI,[EAX+EDI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 038h     ; lea   EBP,[EAX+EDI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 030h     ; lea   EAX,[EAX+ESI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 030h     ; lea   EBX,[EAX+ESI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 030h     ; lea   ECX,[EAX+ESI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 030h     ; lea   EDX,[EAX+ESI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 030h     ; lea   ESI,[EAX+ESI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 030h     ; lea   EDI,[EAX+ESI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 030h     ; lea   EBP,[EAX+ESI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 038h     ; lea   EAX,[EAX+EDI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 038h     ; lea   EBX,[EAX+EDI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 038h     ; lea   ECX,[EAX+EDI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 038h     ; lea   EDX,[EAX+EDI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 038h     ; lea   ESI,[EAX+EDI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 038h     ; lea   EDI,[EAX+EDI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 038h     ; lea   EBP,[EAX+EDI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 030h     ; lea   EAX,[EAX+ESI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 030h     ; lea   EBX,[EAX+ESI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 030h     ; lea   ECX,[EAX+ESI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 030h     ; lea   EDX,[EAX+ESI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 030h     ; lea   ESI,[EAX+ESI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 030h     ; lea   EDI,[EAX+ESI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 030h     ; lea   EBP,[EAX+ESI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 038h     ; lea   EAX,[EAX+EDI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 038h     ; lea   EBX,[EAX+EDI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 038h     ; lea   ECX,[EAX+EDI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 038h     ; lea   EDX,[EAX+EDI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 038h     ; lea   ESI,[EAX+EDI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 038h     ; lea   EDI,[EAX+EDI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 038h     ; lea   EBP,[EAX+EDI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 030h     ; lea   EAX,[EAX+ESI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 030h     ; lea   EBX,[EAX+ESI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 030h     ; lea   ECX,[EAX+ESI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 030h     ; lea   EDX,[EAX+ESI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 030h     ; lea   ESI,[EAX+ESI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 030h     ; lea   EDI,[EAX+ESI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 030h     ; lea   EBP,[EAX+ESI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 038h     ; lea   EAX,[EAX+EDI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 038h     ; lea   EBX,[EAX+EDI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 038h     ; lea   ECX,[EAX+EDI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 038h     ; lea   EDX,[EAX+EDI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 038h     ; lea   ESI,[EAX+EDI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 038h     ; lea   EDI,[EAX+EDI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 038h     ; lea   EBP,[EAX+EDI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 030h     ; lea   EAX,[EAX+ESI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 030h     ; lea   EBX,[EAX+ESI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 030h     ; lea   ECX,[EAX+ESI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 030h     ; lea   EDX,[EAX+ESI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 030h     ; lea   ESI,[EAX+ESI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 030h     ; lea   EDI,[EAX+ESI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 030h     ; lea   EBP,[EAX+ESI+12345678h]

instr2 40h MODF_EAX    DB  08Dh 084h 038h     ; lea   EAX,[EAX+EDI+12345678h]
instr2 40h MODF_EBX    DB  08Dh 09Ch 038h     ; lea   EBX,[EAX+EDI+12345678h]
instr2 40h MODF_ECX    DB  08Dh 08Ch 038h     ; lea   ECX,[EAX+EDI+12345678h]
instr2 40h MODF_EDX    DB  08Dh 094h 038h     ; lea   EDX,[EAX+EDI+12345678h]
instr2 40h MODF_ESI    DB  08Dh 0B4h 038h     ; lea   ESI,[EAX+EDI+12345678h]
instr2 40h MODF_EDI    DB  08Dh 0BCh 038h     ; lea   EDI,[EAX+EDI+12345678h]
instr2 40h MODF_EBP    DB  08Dh 0ACh 038h     ; lea   EBP,[EAX+EDI+12345678h]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; rotations
;
inst MODF_EAX+MODF_FLAGS        rcl   EAX,CL
inst MODF_EBX+MODF_FLAGS        rcl   EBX,CL
inst MODF_EDX+MODF_FLAGS        rcl   EDX,CL
inst MODF_ESI+MODF_FLAGS        rcl   ESI,CL
inst MODF_EDI+MODF_FLAGS        rcl   EDI,CL
inst MODF_EBP+MODF_FLAGS        rcl   EBP,CL
inst MODF_EAX+MODF_FLAGS        rcr   EAX,CL
inst MODF_EBX+MODF_FLAGS        rcr   EBX,CL
inst MODF_EDX+MODF_FLAGS        rcr   EDX,CL
inst MODF_ESI+MODF_FLAGS        rcr   ESI,CL
inst MODF_EDI+MODF_FLAGS        rcr   EDI,CL
inst MODF_EBP+MODF_FLAGS        rcr   EBP,CL
inst MODF_EAX+MODF_FLAGS        rol   EAX,CL
inst MODF_EBX+MODF_FLAGS        rol   EBX,CL
inst MODF_EDX+MODF_FLAGS        rol   EDX,CL
inst MODF_ESI+MODF_FLAGS        rol   ESI,CL
inst MODF_EDI+MODF_FLAGS        rol   EDI,CL
inst MODF_EBP+MODF_FLAGS        rol   EBP,CL
inst MODF_EAX+MODF_FLAGS        ror   EAX,CL
inst MODF_EBX+MODF_FLAGS        ror   EBX,CL
inst MODF_EDX+MODF_FLAGS        ror   EDX,CL
inst MODF_ESI+MODF_FLAGS        ror   ESI,CL
inst MODF_EDI+MODF_FLAGS        ror   EDI,CL
inst MODF_EBP+MODF_FLAGS        ror   EBP,CL
inst MODF_EAX+MODF_FLAGS        shl   EAX,CL
inst MODF_EBX+MODF_FLAGS        shl   EBX,CL
inst MODF_EDX+MODF_FLAGS        shl   EDX,CL
inst MODF_ESI+MODF_FLAGS        shl   ESI,CL
inst MODF_EDI+MODF_FLAGS        shl   EDI,CL
inst MODF_EBP+MODF_FLAGS        shl   EBP,CL
inst MODF_EAX+MODF_FLAGS        shr   EAX,CL
inst MODF_EBX+MODF_FLAGS        shr   EBX,CL
inst MODF_EDX+MODF_FLAGS        shr   EDX,CL
inst MODF_ESI+MODF_FLAGS        shr   ESI,CL
inst MODF_EDI+MODF_FLAGS        shr   EDI,CL
inst MODF_EBP+MODF_FLAGS        shr   EBP,CL

inst MODF_EAX+MODF_FLAGS        rcl   EAX,1
inst MODF_EBX+MODF_FLAGS        rcl   EBX,1
inst MODF_EDX+MODF_FLAGS        rcl   EDX,1
inst MODF_ESI+MODF_FLAGS        rcl   ESI,1
inst MODF_EDI+MODF_FLAGS        rcl   EDI,1
inst MODF_EBP+MODF_FLAGS        rcl   EBP,1
inst MODF_EAX+MODF_FLAGS        rcr   EAX,1
inst MODF_EBX+MODF_FLAGS        rcr   EBX,1
inst MODF_EDX+MODF_FLAGS        rcr   EDX,1
inst MODF_ESI+MODF_FLAGS        rcr   ESI,1
inst MODF_EDI+MODF_FLAGS        rcr   EDI,1
inst MODF_EBP+MODF_FLAGS        rcr   EBP,1
inst MODF_EAX+MODF_FLAGS        rol   EAX,1
inst MODF_EBX+MODF_FLAGS        rol   EBX,1
inst MODF_EDX+MODF_FLAGS        rol   EDX,1
inst MODF_ESI+MODF_FLAGS        rol   ESI,1
inst MODF_EDI+MODF_FLAGS        rol   EDI,1
inst MODF_EBP+MODF_FLAGS        rol   EBP,1
inst MODF_EAX+MODF_FLAGS        ror   EAX,1
inst MODF_EBX+MODF_FLAGS        ror   EBX,1
inst MODF_EDX+MODF_FLAGS        ror   EDX,1
inst MODF_ESI+MODF_FLAGS        ror   ESI,1
inst MODF_EDI+MODF_FLAGS        ror   EDI,1
inst MODF_EBP+MODF_FLAGS        ror   EBP,1
inst MODF_EAX+MODF_FLAGS        shl   EAX,1
inst MODF_EBX+MODF_FLAGS        shl   EBX,1
inst MODF_EDX+MODF_FLAGS        shl   EDX,1
inst MODF_ESI+MODF_FLAGS        shl   ESI,1
inst MODF_EDI+MODF_FLAGS        shl   EDI,1
inst MODF_EBP+MODF_FLAGS        shl   EBP,1
inst MODF_EAX+MODF_FLAGS        shr   EAX,1
inst MODF_EBX+MODF_FLAGS        shr   EBX,1
inst MODF_EDX+MODF_FLAGS        shr   EDX,1
inst MODF_ESI+MODF_FLAGS        shr   ESI,1
inst MODF_EDI+MODF_FLAGS        shr   EDI,1

ifin         LABEL NEAR

inst MODF_EBP+MODF_FLAGS        shr   EBP,1

iend         LABEL NEAR

_ITableSize  DD    (iend - ibegin) / (iend - ifin)
             PUBLIC _ITableSize

_ITableI32Count  DD  (iimm32end - ibegin) / (iend - ifin)
                 PUBLIC _ITableI32Count

_ITableOftCount  DD  (imiscend - ibegin) / (iend - ifin)
                 PUBLIC _ITableOftCount


_DATA        ENDS
             END
